/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class AllComponentsBelongToSomeExtensionModel
implements Validation {
    public String getName() {
        return "All components belong to some extension model";
    }

    public String getDescription() {
        return "All components belong to some extension model";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return c -> true;
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.getExtensionModel() == null) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (Validation)this, (String)String.format("The component '%s' doesn't belong to any extension model", component.getIdentifier())));
        }
        return Optional.empty();
    }
}

