/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorMappingValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class SourceErrorMappingAnyLast
extends AbstractErrorMappingValidation {
    public String getName() {
        return "Source error-mapping ANY last";
    }

    public String getDescription() {
        return "Mapping for 'ANY' or empty is put last.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    protected Optional<ValidationResultItem> validateErrorMapping(ComponentAst component, ComponentParameterAst errorMappingsParam, List<ErrorMapping> mappings) {
        if (mappings.stream().filter(this::isErrorMappingWithSourceAny).count() == 1L && !this.isErrorMappingWithSourceAny(mappings.get(mappings.size() - 1))) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)errorMappingsParam, (Validation)this, (String)"Only the last error mapping can have 'ANY' or an empty source type."));
        }
        return Optional.empty();
    }
}

