/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.api;

import org.mule.runtime.api.lifecycle.Initialisable;

import java.util.Map;

/**
 * An interface that combines {@link ConfigurationPropertiesProvider} and {@link Initialisable}, allowing implementations to
 * access methods from both interfaces.
 */
public interface InitialisableConfigurationPropertiesProvider extends ConfigurationPropertiesProvider, Initialisable {

  /**
   * Retrieves the configuration attributes.
   *
   * @return a map containing configuration properties, where the key is the property name and the value is the corresponding
   *         {@link ConfigurationProperty} object.
   */
  Map<String, ConfigurationProperty> getConfigurationAttributes();
}
