/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.api;

public interface DefaultConfigurationPropertiesProviderFactory {

  /**
   * Creates and returns an instance of {@code InitialisableConfigurationPropertiesProvider}. This method initializes the
   * configuration properties provider using the specified file location, encoding, resource provider, and default configuration
   * properties provider.
   *
   * @param fileLocation                           the path to the configuration file
   * @param encoding                               the character encoding to use when reading the file
   * @param resourceProvider                       the provider responsible for accessing resources
   * @param defaultConfigurationPropertiesProvider the default provider for configuration properties
   * @return an initialized {@code InitialisableConfigurationPropertiesProvider} instance
   */
  InitialisableConfigurationPropertiesProvider createProvider(String fileLocation, String encoding,
                                                              ResourceProvider resourceProvider,
                                                              DefaultConfigurationPropertiesProvider defaultConfigurationPropertiesProvider);
}
