/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.properties.api;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.function.UnaryOperator;

/**
 * Builds the provider for a custom configuration properties element.
 *
 * @since 1.0
 */
public interface ConfigurationPropertiesProviderFactory {

  /**
   * @return the component identifier of the supported element.
   */
  ComponentIdentifier getSupportedComponentIdentifier();

  /**
   * Builds a properties provider for the provided {@code providerElementDeclaration}.
   *
   * @param providerElementDeclaration the configuration parameters, after resolving property placeholders
   * @param localResolver              the resolver of property placeholders found in the provided declaration
   * @param externalResourceProvider   the resource provider for locating files (such as .properties and .yaml)
   * @return the properties provider
   */
  ConfigurationPropertiesProvider createProvider(ComponentAst providerElementDeclaration,
                                                 UnaryOperator<String> localResolver,
                                                 ResourceProvider externalResourceProvider);
}
