/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type.context;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.TransactionProfilingEventType;
import org.mule.runtime.api.tx.TransactionType;

/**
 * {@link ProfilingEventContext} for {@link TransactionProfilingEventType}. Contains relevant data about the transaction.
 */
@NoImplement
@Experimental
public interface TransactionProfilingEventContext extends ProfilingEventContext {

  /**
   * @return the {@link TransactionType} of this transaction.
   */
  TransactionType getType();

  /**
   * @return the location where this transaction was started originally.
   */
  String getTransactionOriginatingLocation();

  /**
   * @return the current location in which this event was generated. For {@link RuntimeProfilingEventTypes#TX_START} this will be
   *         the same as the originating location.
   */
  ComponentLocation getEventOrginatingLocation();

}
