/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.tracing;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;

/**
 * Service that provides access to the {@link ExecutionContext} implementation. Will be escalated to support other tracing
 * capabilities.
 */
@NoImplement
@Experimental
public interface TracingService {

  /**
   * @return The current {@link ExecutionContext}, that can be null.
   */
  ExecutionContext getCurrentExecutionContext();

  /**
   * Deletes the current {@link ExecutionContext}.
   */
  void deleteCurrentExecutionContext();

  /**
   * Sets the current {@link ExecutionContext} to the provided value.
   *
   * @param executionContext An {@link ExecutionContext} that cannot be null.
   * @return The provided {@link ExecutionContext}.
   */
  ExecutionContext setCurrentExecutionContext(ExecutionContext executionContext);

}

