/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type;

import org.mule.runtime.api.profiling.type.context.ExtensionProfilingEventContext;

/**
 * A {@link ProfilingEventType} that indicates that an event associated to an extension has happened. This is intended to be used
 * only by extensions and only generic information can be retrieved through them. An extension will inject the profilingService
 * and then always obtain a data producer for {@link RuntimeProfilingEventTypes#EXTENSION_PROFILING_EVENT}
 *
 * <code>
 *      &#64;Inject
 *      private ProfilingService profilingService;
 *
 *
 *       // trigger a profiling event
 *       profilingService.getProfilingDataProducer(EXTENSION_PROFILING_EVENT).event(data);
 *  </code>
 *
 * @see ExtensionProfilingEventContext#get(String)
 *
 * @since 1.0.0
 */
public class ExtensionProfilingEventType implements ProfilingEventType<ExtensionProfilingEventContext> {

  private final String profilingEventTypeIdentifier;
  private final String profilingEventTypeNamespace;

  public ExtensionProfilingEventType(String profilingEventTypeIdentifier, String profilingEventTypeNamespace) {
    this.profilingEventTypeIdentifier = profilingEventTypeIdentifier;
    this.profilingEventTypeNamespace = profilingEventTypeNamespace;
  }

  @Override
  public String getProfilingEventTypeIdentifier() {
    return profilingEventTypeIdentifier;
  }

  @Override
  public String getProfilingEventTypeNamespace() {
    return profilingEventTypeNamespace;
  }
}
