/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.profiling.type.context;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.threading.ThreadSnapshot;
import org.mule.runtime.api.profiling.type.ProcessingStrategyProfilingEventType;
import org.mule.runtime.api.profiling.type.ProfilingEventType;

import java.util.Optional;

/**
 * {@link ProfilingEventContext} for component threading related {@link ProfilingEventType}'s. This defines the data associated to
 * component threading profiling event types.
 *
 * @see ProcessingStrategyProfilingEventType
 * @since 1.0
 */
@NoImplement
@Experimental
public interface ComponentThreadingProfilingEventContext extends ComponentProfilingEventContext {

  /**
   * @return {@link ThreadSnapshot} containing a snapshot of the profiling event thread state.
   */
  Optional<ThreadSnapshot> getThreadSnapshot();

  void setThreadSnapshot(ThreadSnapshot threadSnapshot);
}
