/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import static org.mule.runtime.module.troubleshooting.internal.TroubleshootingTestUtils.mockServiceRepository;
import static org.mule.test.allure.AllureConstants.SupportabilityFeature.SUPPORTABILITY;
import static org.mule.test.allure.AllureConstants.SupportabilityFeature.SupportabilityStory.SCHEDULERS;

import static java.util.Collections.emptyMap;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.service.ServiceRepository;

import java.io.IOException;
import java.io.StringWriter;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(SUPPORTABILITY)
@Story(SCHEDULERS)
class SchedulersStateOperationTestCase {

  private ServiceRepository serviceRepository;
  private SchedulersStateOperation schedulersStateOperation;

  @BeforeEach
  public void setup() {
    serviceRepository = mockServiceRepository();
    schedulersStateOperation = new SchedulersStateOperation(serviceRepository);
  }

  @Test
  void allSchedulers() throws IOException {
    final var writer = new StringWriter();
    schedulersStateOperation.getCallback().execute(emptyMap(), writer);
    Object result = writer.toString();

    var expected = """
        "Sch 1" (CPU_LITE)
          Active tasks: 8
          Queued tasks: 35
           Rejections:   2 /   6 /   13 /   24

        "Sch 2" (IO)
          Active tasks: 3
           Throttles:    2 /   7 /   14 /   27

        """;
    assertThat(result, is(equalTo(expected)));
  }

}
