/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.dsl.model;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.module.tooling.internal.dsl.declaration.AstXmlArtifactDeclarationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface XmlArtifactDeclarationLoader {
    public static XmlArtifactDeclarationLoader getDefault(DslResolvingContext context) {
        if (Initializer.LOADER_CLASS == null) {
            return new AstXmlArtifactDeclarationLoader(context);
        }
        try {
            return (XmlArtifactDeclarationLoader)Initializer.LOADER_CLASS.getConstructor(DslResolvingContext.class).newInstance(context);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Initializer.LOGGER.warn(e.getClass().getName() + ": " + e.getMessage());
            return new AstXmlArtifactDeclarationLoader(context);
        }
    }

    public ArtifactDeclaration load(InputStream var1);

    public ArtifactDeclaration load(String var1, InputStream var2);

    public static final class Initializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(Initializer.class);
        private static Class<?> LOADER_CLASS;

        private Initializer() {
        }

        static {
            String loaderClassName = System.getProperty(XmlArtifactDeclarationLoader.class.getName() + ".loaderClassName");
            if (loaderClassName == null) {
                LOADER_CLASS = null;
            } else {
                try {
                    LOADER_CLASS = Class.forName(loaderClassName);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn(e.getClass().getName() + ": " + e.getMessage());
                    LOADER_CLASS = null;
                }
            }
        }
    }
}

