/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.sampledata;

import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.sampledata.SampleDataFailure;
import org.mule.runtime.api.sampledata.SampleDataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.tooling.internal.artifact.AbstractParameterResolverExecutor;
import org.mule.runtime.module.tooling.internal.artifact.params.ExpressionNotSupportedException;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDataExecutor
extends AbstractParameterResolverExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataExecutor.class);
    private final SampleDataService sampleDataService;

    public SampleDataExecutor(MuleContext muleContext, ExtendedExpressionManager expressionManager, SampleDataService sampleDataService, ReflectionCache reflectionCache, ArtifactHelper artifactHelper) {
        super(muleContext, expressionManager, reflectionCache, artifactHelper);
        this.sampleDataService = sampleDataService;
    }

    public SampleDataResult getSampleData(ComponentModel componentModel, ComponentElementDeclaration componentElementDeclaration) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Get sample data STARTED for component: {}", (Object)componentModel.getName());
        }
        String componentName = componentElementDeclaration.getName();
        if (!this.getSampleDataProviderModel(componentModel).isPresent()) {
            String message = String.format("Component %s does not support Sample Data", componentName);
            return SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure().withMessage(message).withReason(message).withFailureCode("NOT_SUPPORTED").build());
        }
        ExtensionModel extensionModel = this.artifactHelper.getExtensionModel((ElementDeclaration)componentElementDeclaration);
        String extensionName = extensionModel.getName();
        ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader((ExtensionModel)extensionModel);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking connector's sample data  provider for component: {}", (Object)componentModel.getName());
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(extensionClassLoader);
        try {
            SampleDataResult sampleDataResult = SampleDataResult.resultFrom((Message)this.sampleDataService.getSampleData(extensionName, componentName, this.parameterMapWithDefaults((ParameterizedElementDeclaration)componentElementDeclaration, componentModel), this.getConfigurationInstance(componentElementDeclaration)));
            return sampleDataResult;
        }
        catch (SampleDataException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Get sample data has FAILED with code: %s for component: %s", e.getFailureCode(), componentModel.getName()), (Throwable)e);
            }
            SampleDataResult sampleDataResult = SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure((Throwable)e).withFailureCode(e.getFailureCode()).build());
            return sampleDataResult;
        }
        catch (ExpressionNotSupportedException e) {
            SampleDataResult sampleDataResult = SampleDataResult.resultFrom((SampleDataFailure)SampleDataFailure.Builder.newFailure((Throwable)new SampleDataException(e.getMessage(), "INVALID_PARAMETER_VALUE")).withFailureCode("INVALID_PARAMETER_VALUE").build());
            return sampleDataResult;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new MuleRuntimeException((Throwable)e);
            }
            if (cause instanceof SampleDataException) {
                SampleDataException sampleDataException = (SampleDataException)cause;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("Get sample data has FAILED with code: %s for component: %s", sampleDataException.getFailureCode(), componentModel.getName()), (Throwable)e);
                }
                SampleDataFailure.Builder failureBuilder = SampleDataFailure.Builder.newFailure((Throwable)cause);
                failureBuilder.withFailureCode(sampleDataException.getFailureCode());
                SampleDataResult sampleDataResult = SampleDataResult.resultFrom((SampleDataFailure)failureBuilder.build());
                return sampleDataResult;
            }
            Throwables.throwIfInstanceOf((Throwable)e, MuleRuntimeException.class);
            throw new MuleRuntimeException(cause);
        }
        finally {
            currentThread.setContextClassLoader(currentClassLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Get sample data FINISHED for component: {}", (Object)componentModel.getName());
            }
        }
    }

    private Map<String, Object> parameterMapWithDefaults(ParameterizedElementDeclaration componentElementDeclaration, ComponentModel componentModel) {
        Map<String, Object> explicitParameterMaps = this.parametersMap(componentElementDeclaration, (ParameterizedModel)componentModel);
        if (componentModel instanceof HasOutputModel) {
            ((HasOutputModel)componentModel).getSampleDataProviderModel().ifPresent(model -> {
                List actingParameters = model.getParameters().stream().map(ActingParameterModel::getName).collect(Collectors.toList());
                ParameterValueResolver parameterValueResolver = this.parameterValueResolver(componentElementDeclaration, (ParameterizedModel)componentModel);
                componentModel.getAllParameterModels().stream().filter(p -> actingParameters.contains(p.getName())).filter(p -> !explicitParameterMaps.containsKey(p.getName())).filter(p -> !p.isRequired() && p.getDefaultValue() != null).forEach(p -> {
                    try {
                        explicitParameterMaps.put(p.getName(), parameterValueResolver.getParameterValue(p.getName()));
                    }
                    catch (ValueResolvingException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                });
            });
        }
        return explicitParameterMaps;
    }

    private Supplier<Optional<ConfigurationInstance>> getConfigurationInstance(ComponentElementDeclaration componentElementDeclaration) {
        return () -> {
            Optional<String> optionalConfigRef = Optional.ofNullable(componentElementDeclaration.getConfigRef());
            return optionalConfigRef.map(configRef -> this.artifactHelper.getConfigurationInstance((String)configRef)).orElse(Optional.empty());
        };
    }

    private Optional<SampleDataProviderModel> getSampleDataProviderModel(ComponentModel componentModel) {
        if (componentModel instanceof HasOutputModel) {
            return ((HasOutputModel)componentModel).getSampleDataProviderModel();
        }
        return Optional.empty();
    }
}

