/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.config;

import java.util.Optional;
import java.util.Properties;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.DeploymentInitException;
import org.mule.runtime.deployment.model.api.DeploymentStartException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.tooling.internal.ApplicationSupplier;
import org.mule.runtime.module.tooling.internal.config.DefaultDeclarationSession;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultDeclarationSessionTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private static final String EXPECTED_EXCEPTION = "Expected exception";
    private static final String CONFIG_NAME = "configName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ApplicationSupplier applicationSupplier;
    @Mock
    private Application application;

    @Before
    public void before() {
        Properties deploymentProperties = new Properties();
        deploymentProperties.put("mule.application.deployment.lazyInit", Boolean.TRUE.toString());
        Mockito.when((Object)((ApplicationDescriptor)this.application.getDescriptor())).thenReturn((Object)new org.mule.runtime.deployment.model.api.application.ApplicationDescriptor("app", Optional.of(deploymentProperties)));
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByType((Class)ArgumentMatchers.any(Class.class))).thenReturn(Optional.empty());
        ArtifactContext artifactContext = (ArtifactContext)Mockito.mock(ArtifactContext.class);
        Mockito.when((Object)artifactContext.getRegistry()).thenReturn((Object)registry);
        Mockito.when((Object)this.application.getArtifactContext()).thenReturn((Object)artifactContext);
        Mockito.when((Object)this.application.getRegistry()).thenReturn((Object)registry);
    }

    @Test
    public void deploymentException() throws Exception {
        Mockito.when((Object)this.applicationSupplier.get()).thenThrow(new Throwable[]{new DeploymentException(I18nMessageFactory.createStaticMessage((String)EXPECTED_EXCEPTION))});
        DefaultDeclarationSession defaultDeclarationSession = new DefaultDeclarationSession(this.applicationSupplier, null);
        this.expectedException.expect(DeploymentException.class);
        this.expectedException.expectMessage(EXPECTED_EXCEPTION);
        defaultDeclarationSession.testConnection(CONFIG_NAME);
    }

    @Test
    public void deploymentInitException() throws Exception {
        Mockito.when((Object)this.applicationSupplier.get()).thenReturn((Object)this.application);
        ((Application)Mockito.doThrow((Throwable[])new Throwable[]{new DeploymentInitException(I18nMessageFactory.createStaticMessage((String)EXPECTED_EXCEPTION))}).when((Object)this.application)).start();
        DefaultDeclarationSession defaultDeclarationSession = new DefaultDeclarationSession(this.applicationSupplier, null);
        this.expectedException.expect(DeploymentInitException.class);
        this.expectedException.expectMessage(EXPECTED_EXCEPTION);
        defaultDeclarationSession.testConnection(CONFIG_NAME);
    }

    @Test
    public void deploymentStartException() throws Exception {
        Mockito.when((Object)this.applicationSupplier.get()).thenReturn((Object)this.application);
        ((Application)Mockito.doThrow((Throwable[])new Throwable[]{new DeploymentStartException(I18nMessageFactory.createStaticMessage((String)EXPECTED_EXCEPTION))}).when((Object)this.application)).start();
        DefaultDeclarationSession defaultDeclarationSession = new DefaultDeclarationSession(this.applicationSupplier, null);
        this.expectedException.expect(DeploymentStartException.class);
        this.expectedException.expectMessage(EXPECTED_EXCEPTION);
        defaultDeclarationSession.testConnection(CONFIG_NAME);
    }
}

