/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.metadata;

import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.metadata.ScopeOutputMetadataContext;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.RouterInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ScopeInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.internal.context.lazy.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.context.lazy.NoSuchComponentModelException;

public class LazyMetadataService
implements MetadataService,
Initialisable {
    private final Function<Registry, MetadataService> metadataServiceSupplier;
    @Inject
    private LazyComponentInitializerAdapter lazyMuleArtifactContext;
    @Inject
    private Registry registry;
    private MetadataService metadataService;

    public LazyMetadataService(Function<Registry, MetadataService> metadataServiceSupplier) {
        this.metadataServiceSupplier = metadataServiceSupplier;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getMetadataKeys(location));
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location, MetadataKey partialKey) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getMetadataKeys(location, partialKey));
    }

    public MetadataResult<InputMetadataDescriptor> getInputMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getInputMetadata(location, key));
    }

    public MetadataResult<OutputMetadataDescriptor> getOutputMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOutputMetadata(location, key));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOperationMetadata(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getOperationMetadata(location, key));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getSourceMetadata(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getSourceMetadata(location, key));
    }

    public void disposeCache(String id) {
        this.metadataService.disposeCache(id);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(Location location) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getEntityKeys(location));
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(Location location, MetadataKey key) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getEntityMetadata(location, key));
    }

    public MetadataResult<ScopeInputMetadataDescriptor> getScopeInputMetadata(Location location, MetadataKey key, Supplier<MessageMetadataType> scopeInputMessageType) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getScopeInputMetadata(location, key, scopeInputMessageType));
    }

    public MetadataResult<RouterInputMetadataDescriptor> getRouterInputMetadata(Location location, MetadataKey key, Supplier<MessageMetadataType> routerInputMessageType) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getRouterInputMetadata(location, key, routerInputMessageType));
    }

    public MetadataResult<OutputMetadataDescriptor> getScopeOutputMetadata(Location location, MetadataKey key, ScopeOutputMetadataContext ctx) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getScopeOutputMetadata(location, key, ctx));
    }

    public MetadataResult<OutputMetadataDescriptor> getRouterOutputMetadata(Location location, MetadataKey key, RouterOutputMetadataContext ctx) {
        return this.initializeComponent(location).orElseGet(() -> this.metadataService.getRouterOutputMetadata(location, key, ctx));
    }

    private Optional<MetadataResult<?>> initializeComponent(Location location) {
        try {
            this.lazyMuleArtifactContext.initializeComponent(location, false);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionHelper.getRootException((Throwable)e);
            MetadataFailure.Builder builder = MetadataFailure.Builder.newFailure((Exception)e).withMessage(rootCause.getMessage());
            if (rootCause instanceof NoSuchComponentModelException) {
                builder.withFailureCode(FailureCode.COMPONENT_NOT_FOUND);
            }
            return Optional.of(MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{builder.onComponent()}));
        }
        return Optional.empty();
    }

    public void initialise() throws InitialisationException {
        this.metadataService = this.metadataServiceSupplier.apply(this.registry);
    }
}

