/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.discoverer;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.service.api.artifact.IServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.builder.ServiceFileBuilder;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;
import org.mule.runtime.module.service.internal.test.discoverer.ServiceRegistryTestCase;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import org.mule.tck.util.CollectableReference;

@Feature(value="Services")
@Story(value="Service provider discoverer")
public class FileSystemServiceProviderDiscovererTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    private final IServiceClassLoaderFactory serviceClassLoaderFactory = (IServiceClassLoaderFactory)Mockito.mock(IServiceClassLoaderFactory.class);
    private final ArtifactClassLoader containerClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
    private final DescriptorLoaderRepository descriptorLoaderRepository = (DescriptorLoaderRepository)Mockito.mock(DescriptorLoaderRepository.class);
    private final ArtifactDescriptorValidator artifactDescriptorValidator = (ArtifactDescriptorValidator)Mockito.mock(ArtifactDescriptorValidator.class);

    @Before
    public void setUp() throws Exception {
        FooServiceProvider.INVOKED = false;
        BarServiceProvider.INVOKED = false;
        File servicesFolder = MuleFoldersUtil.getServicesFolder();
        MatcherAssert.assertThat((Object)servicesFolder.mkdir(), (Matcher)Matchers.is((Object)true));
        Mockito.when((Object)this.containerClassLoader.getClassLoader()).thenReturn((Object)((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.containerClassLoader.getClassLoaderLookupPolicy()).thenReturn((Object)((ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class)));
        BundleDescriptorLoader bundleDescriptorLoaderMock = (BundleDescriptorLoader)Mockito.mock(BundleDescriptorLoader.class);
        Mockito.when((Object)bundleDescriptorLoaderMock.supportsArtifactType(ArtifactType.SERVICE)).thenReturn((Object)true);
        Mockito.when((Object)((BundleDescriptor)bundleDescriptorLoaderMock.load((File)ArgumentMatchers.any(File.class), (Map)ArgumentMatchers.any(Map.class), (ArtifactType)ArgumentMatchers.eq((Object)ArtifactType.SERVICE)))).thenReturn((Object)new BundleDescriptor.Builder().setGroupId("mockGroupId").setArtifactId("mockArtifactId").setVersion("1.0.0").setClassifier("mule-service").setType("jar").build());
        Mockito.when((Object)((BundleDescriptorLoader)this.descriptorLoaderRepository.get(ArgumentMatchers.anyString(), (ArtifactType)ArgumentMatchers.any(), (Class)MockitoHamcrest.argThat((Matcher)Matchers.equalTo(BundleDescriptorLoader.class))))).thenReturn((Object)bundleDescriptorLoaderMock);
        Mockito.when((Object)((ClassLoaderConfigurationLoader)this.descriptorLoaderRepository.get(ArgumentMatchers.anyString(), (ArtifactType)ArgumentMatchers.any(), (Class)MockitoHamcrest.argThat((Matcher)Matchers.equalTo(ClassLoaderConfigurationLoader.class))))).thenReturn((Object)((ClassLoaderConfigurationLoader)Mockito.mock(ClassLoaderConfigurationLoader.class)));
        ((ArtifactDescriptorValidator)Mockito.doNothing().when((Object)this.artifactDescriptorValidator)).validate((ArtifactDescriptor)ArgumentMatchers.any());
    }

    @Test
    public void discoversNoServices() throws Exception {
        FileSystemServiceProviderDiscoverer serviceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoader, (ArtifactClassLoaderFactory)this.serviceClassLoaderFactory, this.descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder.builder());
        List discover = serviceProviderDiscoverer.discover();
        MatcherAssert.assertThat((Object)discover, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void discoversServices() throws Exception {
        this.installService("fooService", FooServiceProvider.class);
        this.installService("barService", BarServiceProvider.class);
        ArtifactClassLoader serviceClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        Mockito.when((Object)this.serviceClassLoaderFactory.create(ArgumentMatchers.anyString(), (ServiceDescriptor)ArgumentMatchers.any(ServiceDescriptor.class), (ClassLoader)ArgumentMatchers.any(ClassLoader.class), (ClassLoaderLookupPolicy)ArgumentMatchers.any(ClassLoaderLookupPolicy.class))).thenReturn((Object)serviceClassLoader);
        FileSystemServiceProviderDiscoverer serviceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoader, (ArtifactClassLoaderFactory)this.serviceClassLoaderFactory, this.descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder.builder());
        List assemblies = serviceProviderDiscoverer.discover();
        MatcherAssert.assertThat((Object)assemblies.size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)FooServiceProvider.INVOKED, (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)BarServiceProvider.INVOKED, (Matcher)Matchers.is((Object)false));
        assemblies.forEach(l -> l.getServiceProvider().getServiceDefinition());
        MatcherAssert.assertThat((Object)FooServiceProvider.INVOKED, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)BarServiceProvider.INVOKED, (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Issue(value="W-17750750")
    public void serviceClassLoaderCreationDoesNotLeakCallerClassLoader() throws Exception {
        CollectableReference callerClassLoaderReference = new CollectableReference((Object)new URLClassLoader(new URL[0]));
        this.installService("fooService", FooServiceProvider.class);
        AtomicReference accOnServiceClassLoaderCreation = new AtomicReference();
        Mockito.when((Object)this.serviceClassLoaderFactory.create(ArgumentMatchers.anyString(), (ServiceDescriptor)ArgumentMatchers.any(ServiceDescriptor.class), (ClassLoader)ArgumentMatchers.any(ClassLoader.class), (ClassLoaderLookupPolicy)ArgumentMatchers.any(ClassLoaderLookupPolicy.class))).thenAnswer(invocation -> {
            accOnServiceClassLoaderCreation.set(AccessController.getContext());
            return Mockito.mock(MuleArtifactClassLoader.class);
        });
        FileSystemServiceProviderDiscoverer serviceProviderDiscoverer = new FileSystemServiceProviderDiscoverer(this.containerClassLoader, (ArtifactClassLoaderFactory)this.serviceClassLoaderFactory, this.descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder.builder());
        List assemblies = serviceProviderDiscoverer.discover();
        MatcherAssert.assertThat((String)"Should only have the foo service", (Object)assemblies.size(), (Matcher)Matchers.equalTo((Object)1));
        ServiceAssembly fooServiceAssembly = (ServiceAssembly)assemblies.get(0);
        AccessController.doPrivileged(() -> {
            fooServiceAssembly.getClassLoader();
            return null;
        }, FileSystemServiceProviderDiscovererTestCase.mockAccessControlContext((ClassLoader)callerClassLoaderReference.get()));
        MatcherAssert.assertThat((Object)callerClassLoaderReference, (Matcher)Matchers.is((Matcher)Eventually.eventually((Matcher)CollectableReference.collectedByGc())));
    }

    private static AccessControlContext mockAccessControlContext(ClassLoader classLoader) {
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain((CodeSource)Mockito.mock(CodeSource.class), (PermissionCollection)Mockito.mock(PermissionCollection.class), classLoader, new Principal[0])});
    }

    private void installService(String serviceName, Class<? extends ServiceProvider> providerClass) throws Exception {
        this.installService(serviceName, providerClass, false);
    }

    private void installService(String serviceName, Class<? extends ServiceProvider> providerClass, boolean corrupted) throws Exception {
        ServiceFileBuilder fooService = new ServiceFileBuilder(serviceName).forContract(ServiceRegistryTestCase.FooService.class.getName()).withServiceProviderClass(providerClass.getName()).unpack(true);
        if (corrupted) {
            fooService.corrupted();
        }
        Path artifactFile = fooService.getArtifactFile();
        File installedService = new File(MuleFoldersUtil.getServicesFolder(), artifactFile.getFileName().toString());
        FileUtils.moveDirectory((File)artifactFile.toFile(), (File)installedService);
    }

    public static class FooServiceProvider
    implements ServiceProvider {
        private static boolean INVOKED = false;

        public ServiceDefinition getServiceDefinition() {
            INVOKED = true;
            return null;
        }
    }

    public static class BarServiceProvider
    implements ServiceProvider {
        private static boolean INVOKED = false;

        public ServiceDefinition getServiceDefinition() {
            INVOKED = true;
            return null;
        }
    }
}

