/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.manager;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.reflections.ReflectionUtils;
import org.reflections.util.ReflectionUtilsPredicates;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Map<Class<? extends Service>, Service> services = new HashMap<Class<? extends Service>, Service>();

    public void inject(ServiceProvider serviceProvider) throws ServiceResolutionError {
        this.doInject(serviceProvider, Inject.class);
        this.doInject(serviceProvider, javax.inject.Inject.class);
    }

    private void doInject(ServiceProvider serviceProvider, Class<? extends Annotation> injectAnnotation) throws ServiceResolutionError {
        for (Field field : ReflectionUtils.getAllFields(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtilsPredicates.withAnnotation(injectAnnotation)})) {
            this.injectProperty(field.getType(), field::getGenericType, dependency -> {
                field.setAccessible(true);
                field.set(serviceProvider, dependency);
            }, String.format("into field '%s#%s'", field.getDeclaringClass().getName(), field.getName()));
        }
        for (Method method : ReflectionUtils.getAllMethods(serviceProvider.getClass(), (Predicate[])new Predicate[]{ReflectionUtilsPredicates.withAnnotation(injectAnnotation)})) {
            if (method.getParameters().length != 1) continue;
            this.injectProperty(method.getParameterTypes()[0], () -> method.getGenericParameterTypes()[0], dependency -> method.invoke((Object)serviceProvider, dependency), String.format("on method '%s#%s'", method.getDeclaringClass().getName(), method.getName()));
        }
    }

    private void injectProperty(Class<?> dependencyType, Supplier<Type> genericTypeSupplier, PropertyInjector propertyInjector, String injectionTargetDescription) throws ServiceResolutionError {
        Object dependency = this.resolveObjectToInject(dependencyType, genericTypeSupplier, injectionTargetDescription);
        try {
            propertyInjector.inject(dependency);
        }
        catch (Exception e) {
            throw new ServiceResolutionError(String.format("Could not inject dependency %s of type '%s'", injectionTargetDescription, dependencyType.getName()), e);
        }
    }

    private Object resolveObjectToInject(Class<?> dependencyType, Supplier<Type> genericType, String injectionTarget) throws ServiceResolutionError {
        Optional<Object> dependency;
        boolean asOptional = false;
        if (dependencyType.equals(Optional.class)) {
            dependencyType = (Class)((ParameterizedType)genericType.get()).getActualTypeArguments()[0];
            asOptional = true;
        }
        if ((dependency = this.doResolveObjectToInject(dependencyType)) == null && !asOptional) {
            throw new ServiceResolutionError(String.format("Cannot find a service to inject %s of type '%s'", injectionTarget, dependencyType.getName()));
        }
        return asOptional ? Optional.ofNullable(dependency) : dependency;
    }

    private Object doResolveObjectToInject(Class<?> dependencyType) {
        return this.services.entrySet().stream().filter(entry -> dependencyType.isAssignableFrom((Class)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public <S extends Service> void register(S service, Class<? extends S> serviceContract) {
        this.services.put(serviceContract, service);
    }

    public <S extends Service> void register(Class<? extends S> serviceContract, S service) {
        this.services.put(serviceContract, service);
    }

    @Override
    public <S extends Service> void unregister(Class<? extends S> serviceContract) {
        this.services.remove(serviceContract);
    }

    @Override
    public <S extends Service> Optional<S> getService(Class<? extends S> serviceInterface) {
        return this.services.values().stream().filter(serviceInterface::isInstance).map(s -> s).findAny();
    }

    @Override
    public Collection<Service> getAllServices() {
        return new HashSet<Service>(this.services.values());
    }

    @FunctionalInterface
    private static interface PropertyInjector {
        public void inject(Object var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;
    }
}

