/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.manager;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.module.service.internal.manager.DefaultServiceRegistry;
import org.mule.runtime.module.service.internal.manager.LazyServiceProxy;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class LazyServiceTestCase
extends AbstractMuleTestCase {
    private static final String TEST_VALUE = "dubby dubby do";
    private static final String SERVICE_NAME = "test service";
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private ServiceAssembly assembly;
    @Mock
    private ServiceProvider serviceProvider;
    @Mock
    private DefaultServiceRegistry serviceRegistry;
    private TestService lazyService;
    private TestService actualService;

    @Before
    public void before() {
        Mockito.when((Object)this.assembly.getName()).thenReturn((Object)SERVICE_NAME);
        Mockito.when((Object)this.assembly.getServiceContract()).thenReturn(TestService.class);
        Mockito.when((Object)this.assembly.getClassLoader()).thenReturn((Object)TestService.class.getClassLoader());
        Mockito.when((Object)this.assembly.getServiceProvider()).thenReturn((Object)this.serviceProvider);
        this.actualService = (TestService)Mockito.spy((Object)new TestServiceImpl());
        Mockito.when((Object)this.serviceProvider.getServiceDefinition()).thenReturn((Object)new ServiceDefinition(TestService.class, (Service)this.actualService));
        this.lazyService = (TestService)LazyServiceProxy.from((ServiceAssembly)this.assembly, (ServiceRegistry)this.serviceRegistry, null);
    }

    @Test
    public void invokeRealMethod() throws Exception {
        Assert.assertThat((Object)this.lazyService.doSomething(), (Matcher)CoreMatchers.equalTo((Object)TEST_VALUE));
        this.assertInitialised();
        ((TestService)Mockito.verify((Object)this.actualService)).doSomething();
    }

    @Test
    public void assertLifecycleNotPropagatedIfNotInitialised() throws Exception {
        this.lazyService.start();
        this.assertNotInitialised();
        ((TestService)Mockito.verify((Object)this.actualService, (VerificationMode)Mockito.never())).start();
        this.lazyService.stop();
        this.assertNotInitialised();
        ((TestService)Mockito.verify((Object)this.actualService, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void assertLifecyclePropagatedWhenInitialised() throws Exception {
        this.lazyService.start();
        this.assertNotInitialised();
        this.invokeRealMethod();
        ((TestService)Mockito.verify((Object)this.actualService)).start();
        this.lazyService.stop();
        ((TestService)Mockito.verify((Object)this.actualService)).stop();
    }

    @Test
    public void assertLifecyclePropagatedIfInitialised() throws Exception {
        this.invokeRealMethod();
        this.lazyService.start();
        ((TestService)Mockito.verify((Object)this.actualService)).start();
        this.lazyService.stop();
        ((TestService)Mockito.verify((Object)this.actualService)).stop();
    }

    @Test
    public void getNameDoesNotInitialise() throws Exception {
        Assert.assertThat((Object)this.lazyService.getName(), (Matcher)CoreMatchers.equalTo((Object)SERVICE_NAME));
        this.assertNotInitialised();
    }

    @Test
    public void equalsDoesNotInitialise() throws Exception {
        Assert.assertThat((Object)this.lazyService.equals(Mockito.mock(Service.class)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.lazyService.equals(this.lazyService), (Matcher)CoreMatchers.is((Object)true));
        this.assertNotInitialised();
    }

    @Test
    public void hashCodeDoesNotInitialise() throws Exception {
        Assert.assertThat((Object)this.lazyService.equals(Mockito.mock(Service.class)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.lazyService.equals(this.lazyService), (Matcher)CoreMatchers.is((Object)true));
        this.assertNotInitialised();
    }

    private void assertInitialised() throws Exception {
        this.assertInitialisation(Mockito.atLeastOnce());
        ((DefaultServiceRegistry)Mockito.verify((Object)this.serviceRegistry)).inject(this.serviceProvider);
    }

    private void assertNotInitialised() throws Exception {
        this.assertInitialisation(Mockito.never());
        ((DefaultServiceRegistry)Mockito.verify((Object)this.serviceRegistry, (VerificationMode)Mockito.never())).inject(this.serviceProvider);
    }

    private void assertInitialisation(VerificationMode mode) throws Exception {
        ((ServiceAssembly)Mockito.verify((Object)this.assembly, (VerificationMode)mode)).getClassLoader();
        ((ServiceAssembly)Mockito.verify((Object)this.assembly, (VerificationMode)mode)).getServiceProvider();
    }

    public static interface TestService
    extends Service,
    Startable,
    Stoppable {
        public String doSomething();
    }

    public class TestServiceImpl
    implements TestService {
        @Override
        public String doSomething() {
            return LazyServiceTestCase.TEST_VALUE;
        }

        public String getName() {
            return LazyServiceTestCase.SERVICE_NAME;
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }
    }
}

