/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.test.manager;

import java.io.IOException;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.module.service.internal.manager.DefaultMethodInvoker;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultMethodInvokerTestCase
extends AbstractMuleTestCase {
    private static final String MESSAGE = "someMessage";
    private static final String TEST_VALUE = "someValue";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final DefaultMethodInvoker defaultMethodInvoker = new DefaultMethodInvoker();

    @Test
    public void callCorrectMethod() throws Throwable {
        TestObject object = new TestObject();
        Method method = TestObject.class.getMethod("doSomething", new Class[0]);
        Object result = this.defaultMethodInvoker.invoke((Object)object, method, new Object[0]);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)TEST_VALUE));
    }

    @Test
    public void throwRealException() throws Throwable {
        TestObject object = new TestObject();
        Method method = TestObject.class.getMethod("throwSomething", new Class[0]);
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage(MESSAGE);
        this.defaultMethodInvoker.invoke((Object)object, method, new Object[0]);
    }

    public class TestObject {
        public String doSomething() {
            return DefaultMethodInvokerTestCase.TEST_VALUE;
        }

        public String throwSomething() throws IOException {
            throw new IOException(DefaultMethodInvokerTestCase.MESSAGE);
        }
    }
}

