/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.api.discoverer;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;

public class MuleServiceModelLoader {
    private MuleServiceModelLoader() {
    }

    public static MuleServiceModel loadServiceModel(ClassLoader serviceClassLoader) {
        MuleServiceModel muleServiceModel;
        block8: {
            InputStream stream = serviceClassLoader.getResourceAsStream("META-INF/mule-artifact/mule-artifact.json");
            try {
                muleServiceModel = (MuleServiceModel)new MuleServiceModelJsonSerializer().deserialize(IOUtils.toString((InputStream)stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Could not read extension describer on service '%s'", serviceClassLoader), e);
                }
            }
            stream.close();
        }
        return muleServiceModel;
    }

    public static ServiceProvider instantiateServiceProvider(MuleServiceContractModel contractModel) throws ServiceResolutionError {
        String className = contractModel.getServiceProviderClassName();
        return MuleServiceModelLoader.doInstantiateServiceProvider(className);
    }

    public static ServiceProvider doInstantiateServiceProvider(String className) throws ServiceResolutionError {
        Object reflectedObject;
        try {
            reflectedObject = Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ServiceResolutionError("Unable to create service from class: " + className, e);
        }
        if (!(reflectedObject instanceof ServiceProvider)) {
            throw new ServiceResolutionError(String.format("Provided service class '%s' does not implement '%s'", className, ServiceProvider.class.getName()));
        }
        return (ServiceProvider)reflectedObject;
    }
}

