/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.module.service.ReflectionServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ReflectionServiceProviderResolutionHelperTestCase
extends AbstractMuleTestCase {
    private final ReflectionServiceProviderResolutionHelper providerResolutionHelper = new ReflectionServiceProviderResolutionHelper();

    @Test
    public void findsNoDependencies() throws Exception {
        List dependencies = this.providerResolutionHelper.findServiceDependencies((ServiceProvider)Mockito.mock(ServiceProvider.class));
        MatcherAssert.assertThat((Object)dependencies.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void findsDependencies() throws Exception {
        List dependencies = this.providerResolutionHelper.findServiceDependencies((ServiceProvider)new InjectableServiceProvider());
        MatcherAssert.assertThat((Object)dependencies.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)dependencies, (Matcher)Matchers.hasItem(FooService.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void failsIfNonServiceDependencyIsFound() throws Exception {
        this.providerResolutionHelper.findServiceDependencies((ServiceProvider)new NoInjectableServiceProvider());
    }

    @Test
    public void injectsDependencies() throws Exception {
        InjectableServiceProvider serviceProvider = new InjectableServiceProvider();
        ArrayList<ServiceDefinition> resolvedServices = new ArrayList<ServiceDefinition>();
        FooService fooService = (FooService)Mockito.mock(FooService.class);
        resolvedServices.add(new ServiceDefinition(FooService.class, (Service)fooService));
        this.providerResolutionHelper.injectInstance((ServiceProvider)serviceProvider, resolvedServices);
        MatcherAssert.assertThat((Object)serviceProvider.fooService, (Matcher)Is.is((Object)fooService));
    }

    @Test(expected=ServiceResolutionError.class)
    public void detectsMissingDependency() throws Exception {
        InjectableServiceProvider serviceProvider = new InjectableServiceProvider();
        this.providerResolutionHelper.injectInstance((ServiceProvider)serviceProvider, Collections.emptyList());
    }

    public static class NoInjectableServiceProvider
    implements ServiceProvider {
        @Inject
        String message;

        public List<ServiceDefinition> providedServices() {
            return null;
        }
    }

    public static class InjectableServiceProvider
    implements ServiceProvider {
        @Inject
        FooService fooService;

        public List<ServiceDefinition> providedServices() {
            return null;
        }
    }

    public static interface FooService
    extends Service {
    }
}

