/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import org.mule.runtime.module.reboot.MuleContainerBootstrap;

public final class MuleContainerBootstrapUtils {
    public static final String MULE_DOMAIN_FOLDER = "domains";
    public static final String MULE_LOCAL_JAR_FILENAME = "mule-local-install.jar";
    private static final String MULE_APPS_FILENAME = "apps";
    private static final String MULE_LIB_FILENAME = "lib/mule";
    private static final String MULE_TMP_FILENAME = "tmp";
    private static final String MULE_CONF_FILENAME = "conf";

    private MuleContainerBootstrapUtils() {
    }

    public static boolean isStandalone() {
        return MuleContainerBootstrapUtils.getMuleHome() != null;
    }

    public static File getMuleHome() {
        String muleHome = System.getProperty("mule.home");
        return muleHome != null ? new File(muleHome) : null;
    }

    public static File getMuleBase() {
        File muleBase = null;
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            try {
                muleBase = new File(muleBaseVar).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (muleBase == null) {
            muleBase = MuleContainerBootstrapUtils.getMuleHome();
        }
        return muleBase;
    }

    public static File getMuleAppsDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleBase(), MULE_APPS_FILENAME) : null;
    }

    public static File getMuleAppDir(String appName) {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleAppsDir(), appName) : null;
    }

    public static File getMuleLibDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleHome(), MULE_LIB_FILENAME) : null;
    }

    public static File getMuleTmpDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleBase(), MULE_TMP_FILENAME) : null;
    }

    public static File getMuleLocalJarFile() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleLibDir(), MULE_LOCAL_JAR_FILENAME) : null;
    }

    public static File getMuleDomainsDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleBase(), MULE_DOMAIN_FOLDER) : null;
    }

    public static File getMuleConfDir() {
        return MuleContainerBootstrapUtils.isStandalone() ? new File(MuleContainerBootstrapUtils.getMuleBase(), MULE_CONF_FILENAME) : null;
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        URL url = AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl != null ? cl.getResource(resourceName) : null;
        });
        if (url == null) {
            url = AccessController.doPrivileged(() -> MuleContainerBootstrap.class.getClassLoader().getResource(resourceName));
        }
        if (url == null) {
            url = AccessController.doPrivileged(() -> callingClass.getClassLoader().getResource(resourceName));
        }
        return url;
    }
}

