/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.observability.configuration;

import java.nio.file.Path;
import java.time.Duration;

public interface ObservabilitySignalConfiguration {
    public String getStringValue(String var1);

    default public String getStringValue(String key, String defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    default public Path getPathValue(String key) {
        return this.getPathValue(key, null);
    }

    default public Path getPathValue(String key, Path defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Path.of(value, new String[0]);
        }
        return defaultValue;
    }

    default public Boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, null);
    }

    default public Boolean getBooleanValue(String key, Boolean defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    default public Integer getIntValue(String key) {
        return this.getIntValue(key, null);
    }

    default public Integer getIntValue(String key, Integer defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    default public Long getLongValue(String key) {
        return this.getLongValue(key, null);
    }

    default public Long getLongValue(String key, Long defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    default public Double getDoubleValue(String key) {
        return this.getDoubleValue(key, null);
    }

    default public Double getDoubleValue(String key, Double defaultValue) {
        String value = this.getStringValue(key);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    default public Duration getSecondsDurationValue(String key) {
        return this.getSecondsDurationValue(key, null);
    }

    default public Duration getSecondsDurationValue(String key, Duration defaultValue) {
        Long value = this.getLongValue(key);
        if (value != null) {
            return Duration.ofSeconds(value);
        }
        return defaultValue;
    }

    default public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
    }
}

