/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.metadata.internal.cache.DefaultMetadataCache;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="SDK Tooling Support")
@Story(value="Metadata Service")
public class DefaultMetadataCacheTestCase
extends AbstractMuleTestCase {
    private DefaultMetadataCache cache;

    @Before
    public void setUp() throws Exception {
        this.cache = new DefaultMetadataCache();
    }

    @Test
    public void getMissingKey() {
        Optional result = this.cache.get((Serializable)((Object)"missingKey"));
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void putElementFirstTime() {
        int someValue = 0x112333;
        boolean someKey = true;
        Optional result = this.cache.get((Serializable)Integer.valueOf(1));
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Is.is((Object)false));
        this.cache.put((Serializable)Integer.valueOf(1), (Serializable)Integer.valueOf(0x112333));
        result = this.cache.get((Serializable)Integer.valueOf(1));
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Serializable)result.get()), (Matcher)Is.is((Object)0x112333));
    }

    @Test
    public void updateValue() {
        String someValue = "My Value";
        String otherValue = "Updated Value";
        String someKey = "someKey";
        this.cache.put((Serializable)((Object)"someKey"), (Serializable)((Object)"My Value"));
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)((Object)"someKey")).get()), (Matcher)Is.is((Object)"My Value"));
        this.cache.put((Serializable)((Object)"someKey"), (Serializable)((Object)"Updated Value"));
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)((Object)"someKey")).get()), (Matcher)Is.is((Object)"Updated Value"));
    }

    @Test
    public void putAllCreatesAndUpdates() {
        String someValue = "My Value";
        String otherValue = "Updated Value";
        String someKey = "someKey";
        int intValue = 0x112333;
        int otherKey = 10;
        this.cache.put((Serializable)((Object)"someKey"), (Serializable)((Object)"My Value"));
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)((Object)"someKey")).get()), (Matcher)Is.is((Object)"My Value"));
        MatcherAssert.assertThat((Object)this.cache.get((Serializable)Integer.valueOf(10)).isPresent(), (Matcher)Is.is((Object)false));
        ImmutableMap params = ImmutableMap.builder().put((Object)"someKey", (Object)"Updated Value").put((Object)10, (Object)0x112333).build();
        this.cache.putAll((Map)params);
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)((Object)"someKey")).get()), (Matcher)Is.is((Object)"Updated Value"));
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)Integer.valueOf(10)).get()), (Matcher)Is.is((Object)0x112333));
    }

    @Test
    public void computeIfAbsentCreatesValue() throws MetadataResolvingException, ConnectionException {
        String someKey = "someKey";
        String someValue = "My Value";
        MatcherAssert.assertThat((Object)this.cache.get((Serializable)((Object)"someKey")).isPresent(), (Matcher)Is.is((Object)false));
        Serializable result = this.cache.computeIfAbsent((Serializable)((Object)"someKey"), k -> "My Value");
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)"My Value"));
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)((Object)"someKey")).get()), (Matcher)Is.is((Object)"My Value"));
    }

    @Test
    public void computeIfAbsentDoesNotModifyExistingValue() throws MetadataResolvingException, ConnectionException {
        String someKey = "someKey";
        String someValue = "My Value";
        String otherValue = "Other Value";
        this.cache.put((Serializable)((Object)"someKey"), (Serializable)((Object)"My Value"));
        Serializable result = this.cache.computeIfAbsent((Serializable)((Object)"someKey"), k -> "Other Value");
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)"My Value"));
        MatcherAssert.assertThat((Object)((Serializable)this.cache.get((Serializable)((Object)"someKey")).get()), (Matcher)Is.is((Object)"My Value"));
    }
}

