/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal;

import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.runtime.metadata.api.locator.ComponentLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslElementIdHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DslElementIdHelper.class);

    public static String getSourceElementName(DslElementModel<?> elementModel) {
        return elementModel.getDsl().getPrefix() + ":" + DslElementIdHelper.getModelName(elementModel.getModel()).orElse(elementModel.getDsl().getElementName()) + elementModel.getConfiguration().map(c -> (String)c.getParameters().get("name")).filter(Objects::nonNull).map(n -> "[" + n + "]").orElse("");
    }

    public static Optional<String> getModelName(Object model) {
        if (model instanceof NamedObject) {
            return Optional.of(((NamedObject)model).getName());
        }
        if (model instanceof ObjectType) {
            return ExtensionMetadataTypeUtils.getId((MetadataType)((MetadataType)model));
        }
        return Optional.empty();
    }

    public static String sourceElementNameFromSimpleValue(DslElementModel<?> element) {
        return DslElementIdHelper.getModelName(element.getModel()).map(modelName -> StringUtils.isBlank((String)element.getDsl().getPrefix()) ? modelName : element.getDsl().getPrefix() + ":" + modelName).orElseGet(() -> element.getIdentifier().map(Object::toString).orElse(StringUtils.isBlank((String)element.getDsl().getElementName()) ? element.getDsl().getAttributeName() : element.getDsl().getElementName()));
    }

    public static Optional<String> resolveConfigName(DslElementModel<?> elementModel) {
        String configRef;
        Optional<ComponentConfiguration> configuration = elementModel.getConfiguration();
        if (configuration.isPresent() && !StringUtils.isBlank((String)(configRef = (String)configuration.get().getParameters().get("config-ref")))) {
            return Optional.of(configRef);
        }
        return Optional.empty();
    }

    public static Optional<Either<DslElementModel<?>, String>> resolveSimpleValue(DslElementModel<?> element, final ComponentLocator<DslElementModel<?>> locator) {
        if (element == null || !element.getValue().isPresent()) {
            return Optional.empty();
        }
        final String value = element.getValue().get();
        String sourceElementName = DslElementIdHelper.sourceElementNameFromSimpleValue(element);
        if (value.contains("#[")) {
            return Optional.of(Either.right((Object)value));
        }
        final Reference reference = new Reference();
        if (element.getModel() instanceof ParameterModel) {
            final ParameterModel model = (ParameterModel)element.getModel();
            model.getType().accept(new MetadataTypeVisitor(){

                public void visitString(StringType stringType) {
                    if (!model.getAllowedStereotypes().isEmpty()) {
                        DslElementIdHelper.getGlobalElement(value, locator).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                    }
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (model.getDslConfiguration().allowsReferences()) {
                        DslElementIdHelper.getGlobalElement(value, locator).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (model.getDslConfiguration().allowsReferences()) {
                        DslElementIdHelper.getGlobalElement(value, locator).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                    }
                }
            });
        } else if (element.getModel() instanceof MetadataType) {
            ((MetadataType)element.getModel()).accept(new MetadataTypeVisitor(){

                public void visitArrayType(ArrayType arrayType) {
                    DslElementIdHelper.getGlobalElement(value, locator).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                }

                public void visitObject(ObjectType objectType) {
                    boolean canBeGlobal = objectType.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
                    if (canBeGlobal) {
                        DslElementIdHelper.getGlobalElement(value, locator).ifPresent(arg_0 -> ((Reference)reference).set(arg_0));
                    }
                }
            });
        } else {
            LOGGER.warn(String.format("Unknown model type '%s' found for element '%s'", String.valueOf(element.getModel()), element.getIdentifier().map(Object::toString).orElse(sourceElementName)));
        }
        return Optional.of(reference.get() == null ? Either.right((Object)value) : Either.left((Object)((DslElementModel)reference.get())));
    }

    public static Optional<DslElementModel<?>> getGlobalElement(String name, ComponentLocator<DslElementModel<?>> locator) {
        if (!StringUtils.isBlank((String)name)) {
            return locator.get(Location.builder().globalName(name).build());
        }
        return Optional.empty();
    }
}

