/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.internal.cache.ComponentParameterizationBasedMetadataCacheIdGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="SDK Tooling Support")
@Story(value="Metadata Cache")
public class ComponentParameterizationMetadataCacheIdGeneratorFactoryTestCase
extends AbstractMuleTestCase {
    private ConfigurationMetadataCacheIdGenerator configurationMetadataCacheIdGenerator;
    private ComponentParameterizationBasedMetadataCacheIdGenerator metadataCacheIdGenerator;
    private OutputModel staticTypeOutputModel;
    private OperationModel operationModel;

    @Before
    public void setUp() {
        this.configurationMetadataCacheIdGenerator = (ConfigurationMetadataCacheIdGenerator)Mockito.mock(ConfigurationMetadataCacheIdGenerator.class);
        this.metadataCacheIdGenerator = new ComponentParameterizationBasedMetadataCacheIdGenerator(this.configurationMetadataCacheIdGenerator);
        this.staticTypeOutputModel = (OutputModel)Mockito.mock(OutputModel.class);
        Mockito.when((Object)this.staticTypeOutputModel.hasDynamicType()).thenReturn((Object)false);
        Mockito.when((Object)this.staticTypeOutputModel.getType()).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        this.operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"mockOperation");
    }

    @Test
    public void idForComponentMetadataEmptyForStaticMetadata() {
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.staticTypeOutputModel);
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)this.staticTypeOutputModel);
        MatcherAssert.assertThat((Object)this.metadataCacheIdGenerator.getIdForComponentMetadata(ComponentParameterization.builder((ParameterizedModel)this.operationModel).build()), (Matcher)Matchers.is(Optional.empty()));
    }
}

