/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.api.configuration;

/**
 * Configuration properties for the mule runtime OpenTelemetry logging feature.
 *
 * @since 4.10
 */
public class OpenTelemetryLoggingConfigurationProperties {

  private OpenTelemetryLoggingConfigurationProperties() {}

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER = "mule.openTelemetry.logging.exporter";

  /**
   * When set to true, the OpenTelemetry logging exporter is enabled, meaning that it will parse the Open Telemetry logging
   * configuration and export the logs to the configured OpenTelemetry service.
   *
   * @since 4.10.0
   */
  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_ENABLED = MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".enabled";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_LEVEL =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".level";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_CONFIGURATION_FILE_PATH =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".configurationFilePath";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_CONFIGURATION_FILE_NAME =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".configurationFileName";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_DEFAULT_CONFIGURATION_FILE_NAME = "logging-exporter.conf";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TYPE = MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".type";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_ENDPOINT = MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".endpoint";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_COMPRESSION_TYPE =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".compression";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TLS_ENABLED =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".tls.enabled";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_HEADERS = MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".headers";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_CA_FILE_LOCATION =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".tls.caFileLocation";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_TIMEOUT = MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".timeout";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_CERT_FILE_LOCATION =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".tls.certFileLocation";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_KEY_FILE_LOCATION =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".tls.keyFileLocation";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BACKOFF_MULTIPLIER =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".backoff.multiplier";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_INITIAL_BACKOFF =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".backoff.initial";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_MAX_BACKOFF =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".backoff.maximum";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BACKOFF_MAX_ATTEMPTS =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".backoff.maxAttempts";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_MAX_BATCH_SIZE =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".batch.maxSize";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_QUEUE_SIZE =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".batch.queueSize";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_BACKPRESSURE_STRATEGY =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".batch.backPressure.strategy";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_SERVICE_NAME =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".resource.service.name";

  public static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_SERVICE_NAMESPACE =
      MULE_OPEN_TELEMETRY_LOGGING_EXPORTER + ".resource.service.namespace";

}
