/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
module org.mule.runtime.logging.otel {
    requires org.mule.runtime.artifact;
    requires org.mule.runtime.module.observability;
    requires org.mule.runtime.artifact.ast;
    requires org.mule.runtime.container;
    requires org.mule.runtime.properties.config;
    requires org.mule.runtime.core;

    requires java.logging;

    requires com.fasterxml.jackson.databind;
    requires com.google.gson;
    requires io.opentelemetry.sdk.logs;
    requires io.opentelemetry.exporter.otlp;
    requires io.opentelemetry.sdk;
    requires io.opentelemetry.api;
    requires io.opentelemetry.context;
    requires io.opentelemetry.instrumentation.log4j_appender_2_17;
    requires io.opentelemetry.sdk.common;
    requires io.opentelemetry.sdk.trace;
    requires org.apache.logging.log4j.core;
    requires org.apache.commons.lang3;

    exports org.mule.runtime.logging.otel.api.configuration;

    // Directed export to avoid abuse.
    exports org.mule.runtime.logging.otel.impl.export.log4j to org.mule.runtime.log4j;
}