/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.impl.configuration;

/**
 * A back pressure strategy definition for the OpenTelemetry logging exporter.
 */
public enum OpenTelemetryLoggingExporterBackpressureStrategy {

  /**
   * <p>
   * When the export queue is full, a thread trying to add a log record will block until space is freed.
   * </p>
   * <p>
   * Tradeoff: Application or even container performance can be compromised to the point of malfunctioning.
   * </p>
   */
  BLOCK,

  /**
   * <p>
   * When the export queue is full, a thread trying to add a log record will drop the log record.
   * </p>
   * <p>
   * Tradeoff: Potentially missing log records.
   * </p>
   */
  DROP

  // SWAP (not implemented yet, but this will allow a swap to disk of the exceeding log records)

}
