/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.logging.otel.impl.configuration;

/**
 * A transport definition for the OpenTelemetry logging exporter.
 */
public enum OpenTelemetryLoggingExporterTransport {

  /**
   * GRPC transport, that is configured via an {@link GrpcLoggingExporterConfigurator}
   */
  GRPC(new GrpcLoggingExporterConfigurator()),

  /**
   * HTTP transport, that that is configured via an {@link HttpLoggingExporterConfigurator}.
   */
  HTTP(new HttpLoggingExporterConfigurator());

  private final LoggingExporterConfigurator loggingExporterConfigurator;

  OpenTelemetryLoggingExporterTransport(LoggingExporterConfigurator loggingExporterConfigurator) {
    this.loggingExporterConfigurator = loggingExporterConfigurator;
  }

  public LoggingExporterConfigurator getLoggingExporterConfigurator() {
    return loggingExporterConfigurator;
  }

}
