/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.configuration;

import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.logging.otel.impl.configuration.ExporterBackoffConfigurator;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.LoggingExporterConfigurator;
import org.mule.runtime.module.observability.configuration.HeadersParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class GrpcLoggingExporterConfigurator
implements LoggingExporterConfigurator {
    @Override
    public LogRecordExporter configureExporter(ObservabilitySignalConfiguration configuration) {
        String timeout;
        String headers;
        String compressionType;
        OtlpGrpcLogRecordExporterBuilder otlpGrpcLogRecordExporterBuilder = OtlpGrpcLogRecordExporter.builder();
        String endpoint = configuration.getStringValue("mule.openTelemetry.logging.exporter.endpoint");
        if (!StringUtils.isEmpty((CharSequence)endpoint)) {
            otlpGrpcLogRecordExporterBuilder.setEndpoint(endpoint);
        }
        if ((compressionType = configuration.getStringValue("mule.openTelemetry.logging.exporter.compression")) != null) {
            otlpGrpcLogRecordExporterBuilder.setCompression(compressionType);
        }
        if (configuration.getBooleanValue("mule.openTelemetry.logging.exporter.tls.enabled", Boolean.FALSE).booleanValue()) {
            this.configureTls(otlpGrpcLogRecordExporterBuilder, configuration);
        }
        if ((headers = configuration.getStringValue("mule.openTelemetry.logging.exporter.headers")) != null) {
            this.configureHeaders(otlpGrpcLogRecordExporterBuilder, headers);
        }
        if ((timeout = configuration.getStringValue("mule.openTelemetry.logging.exporter.timeout")) != null) {
            this.configureTimeout(otlpGrpcLogRecordExporterBuilder, timeout);
        }
        ExporterBackoffConfigurator.enableBackoffStrategy(otlpGrpcLogRecordExporterBuilder, configuration);
        return otlpGrpcLogRecordExporterBuilder.build();
    }

    private void configureTimeout(OtlpGrpcLogRecordExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpGrpcLogRecordExporterBuilder builder, String headers) throws LogRecordExporterConfiguratorException {
        try {
            HeadersParser.parseHeaders((String)headers).forEach((arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1));
        }
        catch (Exception e) {
            throw new LogRecordExporterConfiguratorException(e);
        }
    }

    private void configureTls(OtlpGrpcLogRecordExporterBuilder builder, ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        GrpcLoggingExporterConfigurator.configureTrustedCertificates(builder, configuration);
        this.configureClientTls(builder, configuration);
    }

    private static void configureTrustedCertificates(OtlpGrpcLogRecordExporterBuilder builder, ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        String caFilePath = configuration.getStringValue("mule.openTelemetry.logging.exporter.tls.caFileLocation");
        if (caFilePath != null) {
            try {
                byte[] caFileBytes = Files.readAllBytes(Paths.get(caFilePath, new String[0]));
                builder.setTrustedCertificates(caFileBytes);
            }
            catch (IOException e) {
                throw new LogRecordExporterConfiguratorException(e);
            }
        }
    }

    private void configureClientTls(OtlpGrpcLogRecordExporterBuilder builder, ObservabilitySignalConfiguration configuration) throws LogRecordExporterConfiguratorException {
        String certFilePath = configuration.getStringValue("mule.openTelemetry.logging.exporter.tls.certFileLocation");
        String keyFilePath = configuration.getStringValue("mule.openTelemetry.logging.exporter.tls.keyFileLocation");
        if (certFilePath != null && keyFilePath != null) {
            try {
                byte[] keyFileBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
                byte[] certFileBytes = Files.readAllBytes(Paths.get(certFilePath, new String[0]));
                builder.setClientTls(keyFileBytes, certFileBytes);
            }
            catch (IOException e) {
                throw new LogRecordExporterConfiguratorException(e);
            }
        }
    }
}

