/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl.export.batch;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryLoggingExporterBackpressureStrategy;
import org.mule.runtime.logging.otel.impl.export.batch.BlockingBatchLogRecordProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockingBatchLogRecordProcessorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BlockingBatchLogRecordProcessorBuilder.class);
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 1000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final LogRecordExporter logRecordExporter;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(1000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private MeterProvider meterProvider = MeterProvider.noop();
    private OpenTelemetryLoggingExporterBackpressureStrategy backpressureStrategy = OpenTelemetryLoggingExporterBackpressureStrategy.BLOCK;

    BlockingBatchLogRecordProcessorBuilder(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    public BlockingBatchLogRecordProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        BlockingBatchLogRecordProcessorBuilder.checkArgument(delay >= 0L, "delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BlockingBatchLogRecordProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BlockingBatchLogRecordProcessorBuilder setExporterTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        BlockingBatchLogRecordProcessorBuilder.checkArgument(timeout >= 0L, "timeout must be non-negative");
        this.exporterTimeoutNanos = timeout == 0L ? Long.MAX_VALUE : unit.toNanos(timeout);
        return this;
    }

    public BlockingBatchLogRecordProcessorBuilder setExporterTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setExporterTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BlockingBatchLogRecordProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        BlockingBatchLogRecordProcessorBuilder.checkArgument(maxQueueSize > 0, "maxQueueSize must be positive.");
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public BlockingBatchLogRecordProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        BlockingBatchLogRecordProcessorBuilder.checkArgument(maxExportBatchSize > 0, "maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BlockingBatchLogRecordProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BlockingBatchLogRecordProcessorBuilder setBackpressureStrategy(OpenTelemetryLoggingExporterBackpressureStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
        return this;
    }

    public BlockingBatchLogRecordProcessor build() {
        if (this.maxExportBatchSize > this.maxQueueSize) {
            logger.warn("maxExportBatchSize should not exceed maxQueueSize. Setting maxExportBatchSize to {} instead of {}", (Object)this.maxQueueSize, (Object)this.maxExportBatchSize);
            this.maxExportBatchSize = this.maxQueueSize;
        }
        return new BlockingBatchLogRecordProcessor(this.logRecordExporter, this.meterProvider, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos, this.backpressureStrategy);
    }

    private static void checkArgument(boolean isValid, String errorMessage) {
        if (!isValid) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

