/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.util.function.Consumer;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.log4j.boot.api.MuleLog4jContextFactory;
import org.mule.runtime.module.log4j.internal.ApplicationReconfigurableLoggerContextSelector;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.SimpleContextSelector;

public final class MuleLog4jConfiguratorUtils {
    private static ApplicationReconfigurableLoggerContextSelector SINGLE_APP_CONTEXT_SELECTOR = new ApplicationReconfigurableLoggerContextSelector();

    private MuleLog4jConfiguratorUtils() {
    }

    public static void configureSelector(MuleLog4jContextFactory contextFactory) {
        if (MuleLog4jConfiguratorUtils.useAppLog4jConfigurationInSingleAppMode()) {
            MuleLog4jConfiguratorUtils.configureSelector(contextFactory, SINGLE_APP_CONTEXT_SELECTOR);
        } else {
            MuleLog4jConfiguratorUtils.configureSelector(contextFactory, System.getProperty("mule.disableLogSeparation") == null);
        }
    }

    public static void configureSelector(MuleLog4jContextFactory contextFactory, boolean logSeparationEnabled) {
        if (logSeparationEnabled) {
            contextFactory.setContextSelector((ContextSelector)new ArtifactAwareContextSelector(), MuleLog4jConfiguratorUtils::disposeIfDisposable);
        } else {
            contextFactory.setContextSelector((ContextSelector)new SimpleContextSelector(), MuleLog4jConfiguratorUtils::disposeIfDisposable);
        }
    }

    public static void configureSelector(MuleLog4jContextFactory contextFactory, ContextSelector contextSelector) {
        contextFactory.setContextSelector(contextSelector, MuleLog4jConfiguratorUtils::disposeIfDisposable);
    }

    private static void disposeIfDisposable(ContextSelector selector) {
        if (selector instanceof Disposable) {
            ((Disposable)selector).dispose();
        }
    }

    public static Consumer<ClassLoader> getDefaultReconfigurationAction() {
        if (MuleLog4jConfiguratorUtils.useAppLog4jConfigurationInSingleAppMode()) {
            return classloader -> SINGLE_APP_CONTEXT_SELECTOR.reconfigureAccordingToAppClassloader((ClassLoader)classloader);
        }
        return cl -> {};
    }

    private static boolean useAppLog4jConfigurationInSingleAppMode() {
        return Boolean.getBoolean("mule.single.app.mode") && Boolean.getBoolean("mule.single.app.mode.container.use.app.log4j.configuration");
    }
}

