/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.junitpioneer.jupiter.SetSystemProperty;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.MuleLoggerContext;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;

@SmallTest
@ExtendWith(value={MockitoExtension.class})
@SetSystemProperty(key="mule.log.context.dispose.delay.millis", value="200")
@ClearSystemProperty(key="log4j.configurationFile")
class ArtifactAwareContextSelectorTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_TEMPLATE_NAME = "policyTemplate";
    private static final String POLICY_TEMPLATE_ARTIFACT_ID = "domain/app/anApp/policy/aPolicy";
    private static final File CONFIG_LOCATION = new File("src/test/resources/log4j2-test-custom.xml");
    private static final int PROBER_TIMEOUT = 5000;
    private static final int PROBER_FREQ = 500;
    private ArtifactAwareContextSelector selector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RegionClassLoader regionClassLoader;
    @Mock
    private DeployableArtifactDescriptor deployableArtifactDescriptor;

    ArtifactAwareContextSelectorTestCase() {
    }

    @BeforeEach
    public void before() throws Exception {
        this.selector = new ArtifactAwareContextSelector();
        Mockito.when((Object)this.regionClassLoader.getArtifactId()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
        Mockito.when((Object)this.regionClassLoader.findLocalResource("log4j2.xml")).thenReturn((Object)CONFIG_LOCATION.toURI().toURL());
        Mockito.when((Object)this.regionClassLoader.findLocalResource("log4j2-test.xml")).thenReturn((Object)CONFIG_LOCATION.toURI().toURL());
        Mockito.when((Object)this.regionClassLoader.getArtifactDescriptor()).thenReturn((Object)this.deployableArtifactDescriptor);
    }

    @AfterEach
    public void after() throws Exception {
        this.dispose();
    }

    @Test
    void classLoaderToContext() {
        MuleLoggerContext context = (MuleLoggerContext)this.selector.getContext("", (ClassLoader)this.regionClassLoader, true);
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.selector.getContext("", (ClassLoader)this.regionClassLoader, true))));
        this.regionClassLoader = (RegionClassLoader)Mockito.mock(RegionClassLoader.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)this.regionClassLoader.getArtifactId()).thenReturn((Object)((Object)((Object)this)).getClass().getName());
        Mockito.when((Object)this.regionClassLoader.getArtifactDescriptor()).thenReturn((Object)this.deployableArtifactDescriptor);
        MatcherAssert.assertThat((Object)context, (Matcher)IsNot.not((Matcher)CoreMatchers.sameInstance((Object)this.selector.getContext("", (ClassLoader)this.regionClassLoader, true))));
    }

    @Test
    void shutdownListener() {
        MuleLoggerContext context = this.getContext();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ShutdownListener.class);
        ((RegionClassLoader)Mockito.verify((Object)this.regionClassLoader)).addShutdownListener((ShutdownListener)captor.capture());
        ShutdownListener listener = (ShutdownListener)captor.getValue();
        MatcherAssert.assertThat((Object)listener, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)context, (Matcher)CoreMatchers.is((Object)this.selector.getContext("", (ClassLoader)this.regionClassLoader, true)));
        listener.execute();
        this.assertStopped(context);
    }

    @Test
    void dispose() throws Exception {
        MuleLoggerContext context = this.getContext();
        this.selector.dispose();
        this.assertStopped(context);
    }

    @Test
    void returnsMuleLoggerContext() {
        LoggerContext ctx = this.selector.getContext("", (ClassLoader)this.regionClassLoader, true);
        MatcherAssert.assertThat((Object)ctx, (Matcher)IsInstanceOf.instanceOf(MuleLoggerContext.class));
        this.assertConfigurationLocation(ctx);
    }

    @Test
    void defaultToLog4jSysPropWhenNoConfigFound() {
        System.setProperty("log4j.configurationFile", "/customLocation/myLogConfig.xml");
        Mockito.when((Object)this.regionClassLoader.findLocalResource(ArgumentMatchers.anyString())).thenReturn(null);
        File expected = new File("/customLocation/myLogConfig.xml");
        LoggerContext ctx = this.selector.getContext("", (ClassLoader)this.regionClassLoader, true);
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)expected.toURI()));
    }

    @Test
    void defaultToConfWhenNoConfigFound() {
        Mockito.when((Object)this.regionClassLoader.findLocalResource(ArgumentMatchers.anyString())).thenReturn(null);
        File expected = MuleFoldersUtil.getConfFolder();
        expected = new File(expected, "log4j2.xml");
        LoggerContext ctx = this.selector.getContext("", (ClassLoader)this.regionClassLoader, true);
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)expected.toURI()));
    }

    @Test
    void usesLoggerContextReaperThread() throws Exception {
        this.dispose();
        this.assertReaperThreadNotRunning();
        this.before();
        MuleLoggerContext context = this.getContext();
        this.selector.removeContext((LoggerContext)context);
        Thread thread = this.getReaperThread();
        MatcherAssert.assertThat((Object)thread, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    void returnsMuleLoggerContextForArtifactClassLoaderChild() {
        URLClassLoader childClassLoader = new URLClassLoader(new URL[0], (ClassLoader)this.regionClassLoader);
        LoggerContext parentCtx = this.selector.getContext("", (ClassLoader)this.regionClassLoader, true);
        LoggerContext childCtx = this.selector.getContext("", (ClassLoader)childClassLoader, true);
        MatcherAssert.assertThat((Object)childCtx, (Matcher)IsInstanceOf.instanceOf(MuleLoggerContext.class));
        MatcherAssert.assertThat((Object)childCtx, (Matcher)CoreMatchers.sameInstance((Object)parentCtx));
    }

    @Test
    void returnsMuleLoggerContextForInternalArtifactClassLoader() {
        MuleArtifactClassLoader serviceClassLoader = new MuleArtifactClassLoader("test", (ArtifactDescriptor)new ApplicationDescriptor("test"), new URL[0], ((Object)((Object)this)).getClass().getClassLoader(), (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class));
        LoggerContext systemContext = this.selector.getContext("", ((Object)((Object)this)).getClass().getClassLoader(), true);
        LoggerContext serviceCtx = this.selector.getContext("", serviceClassLoader.getClassLoader(), true);
        MatcherAssert.assertThat((Object)serviceCtx, (Matcher)IsInstanceOf.instanceOf(MuleLoggerContext.class));
        MatcherAssert.assertThat((Object)serviceCtx, (Matcher)CoreMatchers.sameInstance((Object)systemContext));
    }

    @Test
    void returnsParentContextForPolicyClassloader() throws MalformedURLException {
        URLClassLoader childClassLoader = new URLClassLoader(new URL[0], (ClassLoader)this.regionClassLoader);
        PolicyTemplateDescriptor policyTemplateDescriptor = new PolicyTemplateDescriptor(POLICY_TEMPLATE_NAME);
        RegionClassLoader policyRegionClassLoader = this.getPolicyRegionClassLoader(policyTemplateDescriptor);
        MuleArtifactClassLoader policyClassLoader = this.getPolicyArtifactClassLoader(policyTemplateDescriptor, policyRegionClassLoader);
        LoggerContext appCtx = this.selector.getContext("", (ClassLoader)childClassLoader, true);
        LoggerContext policyCtx = this.selector.getContext("", (ClassLoader)policyClassLoader, true);
        MatcherAssert.assertThat((Object)policyCtx, (Matcher)CoreMatchers.sameInstance((Object)appCtx));
    }

    private void assertReaperThreadNotRunning() {
        PollingProber prober = new PollingProber(5000L, 500L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return ArtifactAwareContextSelectorTestCase.this.getReaperThread() == null;
            }

            public String describeFailure() {
                return "Reaper thread exists from previous test and did not died";
            }
        });
    }

    private Thread getReaperThread() {
        return MuleTestUtils.getRunningThreadByName((String)"logger.context.reaper");
    }

    private MuleLoggerContext getContext() {
        return (MuleLoggerContext)this.selector.getContext("", (ClassLoader)this.regionClassLoader, true);
    }

    private void assertConfigurationLocation(LoggerContext ctx) {
        MatcherAssert.assertThat((Object)ctx.getConfigLocation(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_LOCATION.toURI()));
    }

    private RegionClassLoader getPolicyRegionClassLoader(PolicyTemplateDescriptor policyTemplateDescriptor) {
        return new RegionClassLoader(POLICY_TEMPLATE_ARTIFACT_ID, (ArtifactDescriptor)policyTemplateDescriptor, (ClassLoader)this.regionClassLoader, (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class));
    }

    private MuleArtifactClassLoader getPolicyArtifactClassLoader(PolicyTemplateDescriptor policyTemplateDescriptor, RegionClassLoader policyRegionClassLoader) {
        return new MuleArtifactClassLoader(POLICY_TEMPLATE_ARTIFACT_ID, (ArtifactDescriptor)policyTemplateDescriptor, new URL[0], (ClassLoader)policyRegionClassLoader, (ClassLoaderLookupPolicy)Mockito.mock(ClassLoaderLookupPolicy.class));
    }

    private void assertStopped(final MuleLoggerContext context) {
        final Reference contextWasAccessibleDuringShutdown = new Reference((Object)true);
        PollingProber pollingProber = new PollingProber(1000L, 10L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                if (context.getState().equals((Object)LifeCycle.State.STOPPED)) {
                    MatcherAssert.assertThat((Object)context, (Matcher)IsNot.not((Object)ArtifactAwareContextSelectorTestCase.this.getContext()));
                    return true;
                }
                MuleLoggerContext currentContext = ArtifactAwareContextSelectorTestCase.this.getContext();
                if (currentContext != null && currentContext != context) {
                    contextWasAccessibleDuringShutdown.set((Object)false);
                }
                return false;
            }

            public String describeFailure() {
                return "context was not stopped";
            }
        });
        MatcherAssert.assertThat((Object)((Boolean)contextWasAccessibleDuringShutdown.get()), (Matcher)CoreMatchers.is((Object)true));
    }
}

