/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.Builder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.log4j.internal.LoggerContextConfigurer;
import org.mule.runtime.module.log4j.internal.MuleLoggerContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class LoggerContextConfigurerTestCase
extends AbstractMuleTestCase {
    private static final String CONVERTER_COMPONENT = "Converter";
    private static final String FILE_PATTERN_TEMPLATE_DATE_SECTION = "%d{yyyy-MM-dd}";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private LoggerContextConfigurer contextConfigurer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleLoggerContext context;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, extraInterfaces={Reconfigurable.class})
    private DefaultConfiguration configuration;
    private Object converter;

    @Before
    public void before() {
        this.contextConfigurer = new LoggerContextConfigurer();
        Mockito.when((Object)this.context.isStandalone()).thenReturn((Object)true);
        Mockito.when((Object)this.context.getConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)this.context.getLog4jConfigFile()).thenReturn(null);
        Mockito.when((Object)this.configuration.getAppenders()).thenReturn(Collections.emptyMap());
        this.converter = null;
        ((DefaultConfiguration)Mockito.doAnswer(invocation -> {
            this.converter = invocation.getArguments()[1];
            return null;
        }).when((Object)this.configuration)).addComponent((String)ArgumentMatchers.eq((Object)CONVERTER_COMPONENT), ArgumentMatchers.any());
        Mockito.when((Object)this.configuration.getComponent(CONVERTER_COMPONENT)).thenAnswer(invocation -> this.converter);
    }

    @Test
    public void forceConsoleLog() {
        this.withForceConsoleLog(() -> {
            this.contextConfigurer.update(this.context);
            ArgumentCaptor appenderCaptor = ArgumentCaptor.forClass(ConsoleAppender.class);
            ((Configuration)Mockito.verify((Object)this.context.getConfiguration())).addAppender((Appender)appenderCaptor.capture());
            Appender forcedConsoleAppender = (Appender)appenderCaptor.getValue();
            MatcherAssert.assertThat((Object)forcedConsoleAppender, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)forcedConsoleAppender.getName(), (Matcher)CoreMatchers.equalTo((Object)"Forced-Console"));
            MatcherAssert.assertThat((Object)forcedConsoleAppender.isStarted(), (Matcher)CoreMatchers.is((Object)true));
            LoggerConfig rootLogger = ((AbstractConfiguration)this.context.getConfiguration()).getRootLogger();
            ((LoggerConfig)Mockito.verify((Object)rootLogger)).addAppender(forcedConsoleAppender, Level.ALL, null);
        });
    }

    @Test
    public void replaceColonWithDash() {
        Mockito.when((Object)this.context.getArtifactName()).thenReturn((Object)"my:app");
        Mockito.when((Object)this.context.isArtifactClassloader()).thenReturn((Object)true);
        this.contextConfigurer.update(this.context);
        ArgumentCaptor appenderCaptor = ArgumentCaptor.forClass(RollingFileAppender.class);
        ((Configuration)Mockito.verify((Object)this.context.getConfiguration(), (VerificationMode)Mockito.atLeastOnce())).addAppender((Appender)appenderCaptor.capture());
        MatcherAssert.assertThat((Object)LoggerContextConfigurerTestCase.getFileName((ArgumentCaptor<RollingFileAppender>)appenderCaptor).contains(":"), (Matcher)CoreMatchers.is((Object)false));
    }

    private static String getFileName(ArgumentCaptor<RollingFileAppender> appenderCaptor) {
        String filename = ((RollingFileAppender)appenderCaptor.getValue()).getFileName();
        return filename.substring(filename.lastIndexOf(File.separator) + 1);
    }

    @Test
    public void perAppDefaultAppender() throws Exception {
        Mockito.when((Object)this.context.isArtifactClassloader()).thenReturn((Object)true);
        Mockito.when((Object)this.context.getArtifactDescriptor().getDeploymentProperties()).thenReturn(Optional.empty());
        this.contextConfigurer.update(this.context);
        ArgumentCaptor appenderCaptor = ArgumentCaptor.forClass(RollingFileAppender.class);
        ((Configuration)Mockito.verify((Object)this.context.getConfiguration())).addAppender((Appender)appenderCaptor.capture());
        RollingFileAppender perAppAppender = (RollingFileAppender)appenderCaptor.getValue();
        MatcherAssert.assertThat((Object)perAppAppender, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)perAppAppender.getName(), (Matcher)CoreMatchers.equalTo((Object)"defaultFileAppender"));
        MatcherAssert.assertThat((Object)perAppAppender.isStarted(), (Matcher)CoreMatchers.is((Object)true));
        String filePattern = perAppAppender.getFilePattern();
        String filePatternTemplate = filePattern.substring(filePattern.lastIndexOf(47) + 1);
        String filePatternTemplateDateSuffix = filePatternTemplate.substring(filePatternTemplate.lastIndexOf(46) + 1);
        MatcherAssert.assertThat((Object)filePatternTemplateDateSuffix, (Matcher)CoreMatchers.equalTo((Object)FILE_PATTERN_TEMPLATE_DATE_SECTION));
        LoggerConfig rootLogger = this.context.getConfiguration().getRootLogger();
        ((LoggerConfig)Mockito.verify((Object)rootLogger)).addAppender((Appender)perAppAppender, Level.ALL, null);
    }

    @Test
    public void noAppendersForMutedApplication() throws Exception {
        Mockito.when((Object)this.context.isArtifactClassloader()).thenReturn((Object)true);
        DeployableArtifactDescriptor descriptor = (DeployableArtifactDescriptor)Mockito.mock(DeployableArtifactDescriptor.class);
        Properties properties = new Properties();
        properties.setProperty("mule.application.deployment.muteLog", "true");
        Mockito.when((Object)descriptor.getDeploymentProperties()).thenReturn(Optional.of(properties));
        Mockito.when((Object)this.context.getArtifactDescriptor()).thenReturn((Object)descriptor);
        this.contextConfigurer.update(this.context);
        ((Configuration)Mockito.verify((Object)this.context.getConfiguration(), (VerificationMode)Mockito.never())).addAppender((Appender)ArgumentMatchers.any(Appender.class));
    }

    @Test
    public void forceConsoleLogWithAppenderAlreadyPresent() {
        this.withForceConsoleLog(() -> {
            LoggerConfig rootLogger = ((AbstractConfiguration)this.context.getConfiguration()).getRootLogger();
            ArrayList<Appender> appenders = new ArrayList<Appender>();
            appenders.add((Appender)((Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setLayout((Layout)Mockito.mock(Layout.class))).setName("Console")).build());
            Mockito.when(rootLogger.getAppenders().values()).thenReturn(appenders);
            this.contextConfigurer.update(this.context);
            ((Configuration)Mockito.verify((Object)this.context.getConfiguration(), (VerificationMode)Mockito.never())).addAppender((Appender)ArgumentMatchers.any(ConsoleAppender.class));
            ((LoggerConfig)Mockito.verify((Object)rootLogger, (VerificationMode)Mockito.never())).addAppender((Appender)ArgumentMatchers.any(ConsoleAppender.class), (Level)ArgumentMatchers.same((Object)Level.INFO), (Filter)ArgumentMatchers.any(Filter.class));
        });
    }

    private void withForceConsoleLog(Runnable assertion) {
        System.setProperty("mule.forceConsoleLog", "");
        try {
            assertion.run();
        }
        finally {
            System.clearProperty("mule.forceConsoleLog");
        }
    }
}

