/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.boot.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.module.log4j.boot.api.AsyncLoggerExceptionHandler;
import org.mule.runtime.module.log4j.boot.api.MuleLog4jContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Logging")
@Story(value="Log Context Factory")
public class MuleLog4jContextFactoryTestCase
extends AbstractMuleTestCase {
    private static final String LOG_CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    private static final String ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY = "AsyncLoggerConfig.ExceptionHandler";
    private static final Integer SHUTDOWN_HOOKS_NUMBER = Runtime.getRuntime().availableProcessors();
    private static final Integer LATCH_TIMEOUT_MILLIS = 500;
    private Map<String, String> originalSystemProperties;

    @Before
    public void before() {
        this.originalSystemProperties = new HashMap<String, String>();
        this.originalSystemProperties.put(LOG_CONFIGURATION_FACTORY_PROPERTY, System.getProperty(LOG_CONFIGURATION_FACTORY_PROPERTY));
        this.originalSystemProperties.put(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY, System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY));
    }

    @After
    public void after() {
        for (Map.Entry<String, String> entry : this.originalSystemProperties.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.clearProperty(entry.getKey());
        }
    }

    @Test
    public void systemProperties() {
        MuleLog4jContextFactory factory = new MuleLog4jContextFactory();
        Assert.assertThat((Object)XmlConfigurationFactory.class.getName(), (Matcher)CoreMatchers.equalTo((Object)System.getProperty(LOG_CONFIGURATION_FACTORY_PROPERTY)));
        Assert.assertThat((Object)AsyncLoggerExceptionHandler.class.getName(), (Matcher)CoreMatchers.equalTo((Object)System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY)));
        factory.dispose();
    }

    @Test
    public void customExceptionHandler() {
        String customHandler = "custom";
        System.setProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY, "custom");
        MuleLog4jContextFactory factory = new MuleLog4jContextFactory();
        Assert.assertThat((Object)"custom", (Matcher)CoreMatchers.equalTo((Object)System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY)));
        factory.dispose();
    }

    @Test
    public void dispose() {
        AtomicBoolean disposeCallbackWasCalled = new AtomicBoolean(false);
        ContextSelector contextSelector = (ContextSelector)Mockito.mock(ContextSelector.class);
        MuleLog4jContextFactory factory = new MuleLog4jContextFactory(contextSelector, selector -> disposeCallbackWasCalled.set(true));
        factory.dispose();
        Assert.assertThat((Object)disposeCallbackWasCalled.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Issue(value="MULE-18742")
    @Description(value="If any shutdown callback is cancelled while the log is disposing everything should work")
    public void cancelWhileDisposing() {
        ContextSelector contextSelector = (ContextSelector)Mockito.mock(ContextSelector.class);
        MuleLog4jContextFactory factory = new MuleLog4jContextFactory(contextSelector, selector -> {});
        ShutdownCallbackRegistry shutdownCallbackRegistry = factory.getShutdownCallbackRegistry();
        Latch latch = new Latch();
        AtomicInteger executedHooks = new AtomicInteger();
        Cancellable hookToCancel = shutdownCallbackRegistry.addShutdownCallback(() -> {
            try {
                latch.await((long)LATCH_TIMEOUT_MILLIS.intValue(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            executedHooks.incrementAndGet();
        });
        shutdownCallbackRegistry.addShutdownCallback(() -> {
            hookToCancel.cancel();
            latch.release();
            executedHooks.incrementAndGet();
        });
        for (int i = 0; i < SHUTDOWN_HOOKS_NUMBER - 2; ++i) {
            shutdownCallbackRegistry.addShutdownCallback(executedHooks::incrementAndGet);
        }
        Assert.assertThat((Object)executedHooks.get(), (Matcher)Matchers.is((Object)0));
        factory.dispose();
        Assert.assertThat((Object)executedHooks.get(), (Matcher)Matchers.is((Object)SHUTDOWN_HOOKS_NUMBER));
    }
}

