/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.ArtifactDeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.launcher.coreextension.DefaultMuleCoreExtensionManagerServer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceAware;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Core Extensions")
@Story(value="Dependency injection for core extensions")
public class DefaultMuleCoreExtensionManagerTestCase
extends AbstractMuleTestCase {
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer = (MuleCoreExtensionDiscoverer)Mockito.mock(MuleCoreExtensionDiscoverer.class);
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver = (MuleCoreExtensionDependencyResolver)Mockito.mock(MuleCoreExtensionDependencyResolver.class);
    private MuleCoreExtensionManagerServer coreExtensionManager = new DefaultMuleCoreExtensionManagerServer(this.coreExtensionDiscoverer, this.coreExtensionDependencyResolver);
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void discoversMuleCoreExtension() throws Exception {
        this.coreExtensionManager.initialise();
        ((MuleCoreExtensionDiscoverer)Mockito.verify((Object)this.coreExtensionDiscoverer)).discover();
    }

    @Test
    public void injectsDeploymentServiceAwareCoreExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> this.coreExtensionManager.setDeploymentService(service);
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((TestDeploymentServiceAwareExtension)Mockito.verify((Object)((TestDeploymentServiceAwareExtension)extensions.get(0)))).setDeploymentService((DeploymentService)service);
        this.testServiceInjection(DeploymentService.class, TestDeploymentServiceAwareExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectRepositoryServiceAwareCoreExtension() throws Exception {
        Consumer<RepositoryService> setServiceFunction = service -> this.coreExtensionManager.setRepositoryService(service);
        BiConsumer<List, RepositoryService> verificationFunction = (extensions, service) -> ((TestRepositoryServiceAwareExtension)Mockito.verify((Object)((TestRepositoryServiceAwareExtension)extensions.get(0)))).setRepositoryService((RepositoryService)service);
        this.testServiceInjection(RepositoryService.class, TestRepositoryServiceAwareExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void initializesDeploymentListenerCoreExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> this.coreExtensionManager.setDeploymentService(service);
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((DeploymentService)Mockito.verify((Object)service)).addDeploymentListener((DeploymentListener)extensions.get(0));
        this.testServiceInjection(DeploymentService.class, TestDeploymentListenerExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsCoreExtensionsAwareCoreExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> {};
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((TestCoreExtensionsAwareExtension)Mockito.verify((Object)((TestCoreExtensionsAwareExtension)extensions.get(0)))).setCoreExtensions(new ArrayList(extensions));
        this.testServiceInjection(DeploymentService.class, TestCoreExtensionsAwareExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsDeploymentServiceOnExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = arg_0 -> ((MuleCoreExtensionManagerServer)this.coreExtensionManager).setDeploymentService(arg_0);
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((TestDeploymentServiceExtension)Mockito.verify((Object)((TestDeploymentServiceExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setDeploymentService((DeploymentService)service);
        this.testServiceInjection(DeploymentService.class, TestDeploymentServiceExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectRepositoryServiceOnExtension() throws Exception {
        Consumer<RepositoryService> setServiceFunction = arg_0 -> ((MuleCoreExtensionManagerServer)this.coreExtensionManager).setRepositoryService(arg_0);
        BiConsumer<List, RepositoryService> verificationFunction = (extensions, service) -> ((TestRepositoryServiceExtension)Mockito.verify((Object)((TestRepositoryServiceExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setRepositoryService((RepositoryService)service);
        this.testServiceInjection(RepositoryService.class, TestRepositoryServiceExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsCoreExtensionsOnExtension() throws Exception {
        Consumer<DeploymentService> setServiceFunction = service -> {};
        BiConsumer<List, DeploymentService> verificationFunction = (extensions, service) -> ((TestCoreExtensionsExtension)Mockito.verify((Object)((TestCoreExtensionsExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setCoreExtensions(new ArrayList<MuleCoreExtension>((Collection<MuleCoreExtension>)extensions));
        this.testServiceInjection(DeploymentService.class, TestCoreExtensionsExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsArtifactClassLoaderManagerOnExtension() throws Exception {
        Consumer<ArtifactClassLoaderManager> setServiceFunction = service -> this.coreExtensionManager.setArtifactClassLoaderManager(service);
        BiConsumer<List, ArtifactClassLoaderManager> verificationFunction = (extensions, service) -> ((TestArtifactClassLoaderManagerExtension)Mockito.verify((Object)((TestArtifactClassLoaderManagerExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setArtifactClassLoaderManager((ArtifactClassLoaderManager)ArgumentMatchers.same((Object)service));
        this.testServiceInjection(ArtifactClassLoaderManager.class, TestArtifactClassLoaderManagerExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsToolingServiceOnExtension() throws Exception {
        Consumer<ToolingService> setServiceFunction = arg_0 -> ((MuleCoreExtensionManagerServer)this.coreExtensionManager).setToolingService(arg_0);
        BiConsumer<List, ToolingService> verificationFunction = (extensions, service) -> ((TestToolingServiceExtension)Mockito.verify((Object)((TestToolingServiceExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setToolingService((ToolingService)service);
        this.testServiceInjection(ToolingService.class, TestToolingServiceExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsServiceRepositoryCoreExtension() throws Exception {
        Consumer<ServiceRepository> setServiceFunction = arg_0 -> ((MuleCoreExtensionManagerServer)this.coreExtensionManager).setServiceRepository(arg_0);
        BiConsumer<List, ServiceRepository> verificationFunction = (extensions, service) -> ((TestServiceRepositoryExtension)Mockito.verify((Object)((TestServiceRepositoryExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setServiceRepository((ServiceRepository)service);
        this.testServiceInjection(ServiceRepository.class, TestServiceRepositoryExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsEventContextServiceAwareCoreExtension() throws Exception {
        Consumer<EventContextService> setServiceFunction = arg_0 -> ((MuleCoreExtensionManagerServer)this.coreExtensionManager).setEventContextService(arg_0);
        BiConsumer<List, EventContextService> verificationFunction = (extensions, service) -> ((TestEventContextServiceExtension)Mockito.verify((Object)((TestEventContextServiceExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setEventContextService((EventContextService)service);
        this.testServiceInjection(EventContextService.class, TestEventContextServiceExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void injectsServiceOnExtension() throws Exception {
        LinkedList<InjectedTestServiceExtension> extensions = new LinkedList<InjectedTestServiceExtension>();
        InjectedTestServiceExtension extension = (InjectedTestServiceExtension)Mockito.mock(InjectedTestServiceExtension.class);
        extensions.add(extension);
        TestService service = (TestService)Mockito.mock(TestService.class);
        Mockito.when((Object)service.getName()).thenReturn((Object)"testService");
        ServiceRepository serviceRepository = (ServiceRepository)Mockito.mock(ServiceRepository.class);
        Mockito.when((Object)serviceRepository.getServices()).thenReturn(Collections.singletonList(service));
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(extensions);
        this.coreExtensionManager.setServiceRepository(serviceRepository);
        this.coreExtensionManager.initialise();
        ((InjectedTestServiceExtension)Mockito.verify((Object)extension, (VerificationMode)Mockito.atLeastOnce())).setService(service);
    }

    @Test
    @Issue(value="W-14237711")
    @Feature(value="Lock factory")
    @Story(value="Container level lock factory")
    public void injectsServerLockFactoryOnExtension() throws Exception {
        Consumer<ServerLockFactory> setServiceFunction = arg_0 -> ((MuleCoreExtensionManagerServer)this.coreExtensionManager).setServerLockFactory(arg_0);
        BiConsumer<List, ServerLockFactory> verificationFunction = (extensions, service) -> ((TestLockFactoryExtension)Mockito.verify((Object)((TestLockFactoryExtension)extensions.get(0)), (VerificationMode)Mockito.atLeastOnce())).setServerLockFactory((ServerLockFactory)service);
        this.testServiceInjection(ServerLockFactory.class, TestLockFactoryExtension.class, setServiceFunction, verificationFunction);
    }

    @Test
    public void startsCoreExtensionsInOrder() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension2);
        orderedExtensions.add(extension1);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((MuleCoreExtension)ordered.verify((Object)extension2)).start();
        ((MuleCoreExtension)ordered.verify((Object)extension1)).start();
    }

    @Test
    public void stopsCoreExtensionsInOrder() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension1);
        orderedExtensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        this.coreExtensionManager.stop();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((MuleCoreExtension)ordered.verify((Object)extension2)).stop();
        ((MuleCoreExtension)ordered.verify((Object)extension1)).stop();
    }

    @Test
    public void stopsCoreExtensionsAfterStartFail() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        RuntimeException firstStartFailure = new RuntimeException();
        ((MuleCoreExtension)Mockito.doThrow((Throwable[])new Throwable[]{firstStartFailure}).when((Object)extension1)).start();
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        extensions.add(extension1);
        extensions.add(extension2);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension1);
        orderedExtensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        try {
            this.coreExtensionManager.start();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.sameInstance((Object)firstStartFailure));
        }
        this.coreExtensionManager.stop();
        ((MuleCoreExtension)Mockito.verify((Object)extension2, (VerificationMode)Mockito.never())).stop();
    }

    @Test
    public void initializesCoreExtensionsInOrder() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension2);
        orderedExtensions.add(extension1);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((MuleCoreExtension)ordered.verify((Object)extension2)).initialise();
        ((MuleCoreExtension)ordered.verify((Object)extension1)).initialise();
    }

    @Test
    public void disposesCoreExtensions() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        TestDeploymentServiceAwareExtension extension1 = (TestDeploymentServiceAwareExtension)Mockito.mock(TestDeploymentServiceAwareExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension1);
        extensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension1);
        orderedExtensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.dispose();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{extension1, extension2});
        ((TestDeploymentServiceAwareExtension)inOrder.verify((Object)extension1)).dispose();
        ((MuleCoreExtension)inOrder.verify((Object)extension2)).dispose();
    }

    @Test
    public void disposesCoreExtensionsAfterStartFail() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension1 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        MuleCoreExtension extension2 = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        RuntimeException firstStartFailure = new RuntimeException();
        ((MuleCoreExtension)Mockito.doThrow((Throwable[])new Throwable[]{firstStartFailure}).when((Object)extension1)).initialise();
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        extensions.add(extension1);
        extensions.add(extension2);
        LinkedList<MuleCoreExtension> orderedExtensions = new LinkedList<MuleCoreExtension>();
        orderedExtensions.add(extension1);
        orderedExtensions.add(extension2);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(orderedExtensions);
        try {
            this.coreExtensionManager.initialise();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.sameInstance((Object)firstStartFailure));
        }
        this.coreExtensionManager.dispose();
        ((MuleCoreExtension)Mockito.verify((Object)extension2, (VerificationMode)Mockito.never())).dispose();
    }

    @Test
    public void resolvesCoreExtensionDependencies() throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension = (MuleCoreExtension)Mockito.mock(MuleCoreExtension.class);
        extensions.add(extension);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        this.coreExtensionManager.initialise();
        ((MuleCoreExtensionDependencyResolver)Mockito.verify((Object)this.coreExtensionDependencyResolver)).resolveDependencies(extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllCoreExtensionsAreStoppedAfterRuntimeException() throws Exception {
        TestDeploymentServiceAwareExtension extensionFailsStops = (TestDeploymentServiceAwareExtension)Mockito.mock(TestDeploymentServiceAwareExtension.class);
        TestDeploymentServiceAwareExtension extensionStopsOk = (TestDeploymentServiceAwareExtension)Mockito.mock(TestDeploymentServiceAwareExtension.class);
        InOrder stopsInOrder = Mockito.inOrder((Object[])new Object[]{extensionFailsStops, extensionStopsOk});
        LinkedList<TestDeploymentServiceAwareExtension> extensions = new LinkedList<TestDeploymentServiceAwareExtension>();
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(extensions);
        ((TestDeploymentServiceAwareExtension)Mockito.doThrow(RuntimeException.class).when((Object)extensionFailsStops)).stop();
        extensions.add(extensionStopsOk);
        extensions.add(extensionFailsStops);
        this.coreExtensionManager.initialise();
        this.coreExtensionManager.start();
        try {
            this.coreExtensionManager.stop();
        }
        finally {
            ((TestDeploymentServiceAwareExtension)stopsInOrder.verify((Object)extensionFailsStops)).stop();
            ((TestDeploymentServiceAwareExtension)stopsInOrder.verify((Object)extensionStopsOk)).stop();
        }
    }

    @Test
    public void initializesArtifactDeploymentListenerCoreExtension() throws Exception {
        this.assertArtifactDeploymentListener((ArtifactDeploymentListener)Mockito.mock(TestArtifactDeploymentListenerExtension.class));
    }

    private <ServiceType, CoreExtensionType extends MuleCoreExtension> void testServiceInjection(Class<ServiceType> serviceType, Class<CoreExtensionType> coreExtensionType, Consumer<ServiceType> setServiceFunction, BiConsumer<List<CoreExtensionType>, ServiceType> verificationFunction) throws MuleException {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        MuleCoreExtension extension = (MuleCoreExtension)Mockito.mock(coreExtensionType);
        extensions.add(extension);
        Object service = Mockito.mock(serviceType);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(extensions);
        setServiceFunction.accept(service);
        this.coreExtensionManager.initialise();
        verificationFunction.accept(extensions, service);
    }

    private void assertArtifactDeploymentListener(ArtifactDeploymentListener extension) throws Exception {
        LinkedList<MuleCoreExtension> extensions = new LinkedList<MuleCoreExtension>();
        extensions.add((MuleCoreExtension)extension);
        Mockito.when((Object)this.coreExtensionDiscoverer.discover()).thenReturn(extensions);
        Mockito.when((Object)this.coreExtensionDependencyResolver.resolveDependencies(extensions)).thenReturn(extensions);
        DeploymentService deploymentService = (DeploymentService)Mockito.mock(DeploymentService.class);
        TestMuleCoreExtensionManager testCoreExtensionManager = new TestMuleCoreExtensionManager(this.coreExtensionDiscoverer, this.coreExtensionDependencyResolver);
        testCoreExtensionManager.setDeploymentService(deploymentService);
        testCoreExtensionManager.initialise();
        ((DeploymentService)Mockito.verify((Object)deploymentService)).addDomainDeploymentListener(testCoreExtensionManager.domainDeploymentListener);
        ((DeploymentService)Mockito.verify((Object)deploymentService)).addDeploymentListener(testCoreExtensionManager.applicationDeploymentListener);
    }

    public static interface TestDeploymentServiceAwareExtension
    extends MuleCoreExtension,
    DeploymentServiceAware {
    }

    public static interface TestRepositoryServiceAwareExtension
    extends MuleCoreExtension,
    RepositoryServiceAware {
    }

    public static interface TestDeploymentListenerExtension
    extends MuleCoreExtension,
    DeploymentListener {
    }

    public static interface TestCoreExtensionsAwareExtension
    extends MuleCoreExtension,
    CoreExtensionsAware {
    }

    public static interface TestDeploymentServiceExtension
    extends MuleCoreExtension {
        @Inject
        public void setDeploymentService(DeploymentService var1);
    }

    public static interface TestRepositoryServiceExtension
    extends MuleCoreExtension {
        @Inject
        public void setRepositoryService(RepositoryService var1);
    }

    public static interface TestCoreExtensionsExtension
    extends MuleCoreExtension {
        @Inject
        public void setCoreExtensions(List<MuleCoreExtension> var1);
    }

    public static interface TestArtifactClassLoaderManagerExtension
    extends MuleCoreExtension {
        @Inject
        public void setArtifactClassLoaderManager(ArtifactClassLoaderManager var1);
    }

    public static interface TestToolingServiceExtension
    extends MuleCoreExtension {
        @Inject
        public void setToolingService(ToolingService var1);
    }

    public static interface TestServiceRepositoryExtension
    extends MuleCoreExtension {
        @Inject
        public void setServiceRepository(ServiceRepository var1);
    }

    public static interface TestEventContextServiceExtension
    extends MuleCoreExtension {
        @Inject
        public void setEventContextService(EventContextService var1);
    }

    public static interface InjectedTestServiceExtension
    extends MuleCoreExtension {
        @Inject
        public void setService(TestService var1);
    }

    public static interface TestService
    extends Service {
    }

    public static interface TestLockFactoryExtension
    extends MuleCoreExtension {
        @Inject
        public void setServerLockFactory(ServerLockFactory var1);
    }

    public static interface TestArtifactDeploymentListenerExtension
    extends MuleCoreExtension,
    ArtifactDeploymentListener {
    }

    private static class TestMuleCoreExtensionManager
    extends DefaultMuleCoreExtensionManagerServer {
        DeploymentListener applicationDeploymentListener;
        DeploymentListener domainDeploymentListener;

        public TestMuleCoreExtensionManager(MuleCoreExtensionDiscoverer coreExtensionDiscoverer, MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver) {
            super(coreExtensionDiscoverer, coreExtensionDependencyResolver);
        }

        DeploymentListener createDeploymentListenerAdapter(ArtifactDeploymentListener artifactDeploymentListener, ArtifactType type) {
            if (type == ArtifactType.APP) {
                this.applicationDeploymentListener = super.createDeploymentListenerAdapter(artifactDeploymentListener, type);
                return this.applicationDeploymentListener;
            }
            this.domainDeploymentListener = super.createDeploymentListenerAdapter(artifactDeploymentListener, type);
            return this.domainDeploymentListener;
        }
    }
}

