/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.ArtifactClassLoaderManagerAware;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.internal.lock.ServerLockFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.ArtifactDeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.deployment.internal.DeploymentListenerAdapter;
import org.mule.runtime.module.launcher.coreextension.ContainerInjectorBuilder;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceAware;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleCoreExtensionManagerServer
implements MuleCoreExtensionManagerServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleCoreExtensionManagerServer.class);
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer;
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver;
    private List<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
    private DeploymentService deploymentService;
    private RepositoryService repositoryService;
    private ToolingService toolingService;
    private List<MuleCoreExtension> orderedCoreExtensions;
    private ArtifactClassLoaderManager artifactClassLoaderManager;
    private ServiceRepository serviceRepository;
    private EventContextService eventContextService;
    private TroubleshootingService troubleshootingService;
    private List<MuleCoreExtension> initializedCoreExtensions = new ArrayList<MuleCoreExtension>();
    private List<MuleCoreExtension> startedCoreExtensions = new ArrayList<MuleCoreExtension>();
    private ServerLockFactory serverLockFactory;

    public DefaultMuleCoreExtensionManagerServer(MuleCoreExtensionDiscoverer coreExtensionDiscoverer, MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver) {
        this.coreExtensionDiscoverer = coreExtensionDiscoverer;
        this.coreExtensionDependencyResolver = coreExtensionDependencyResolver;
    }

    public void dispose() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Disposing core extensions");
        }
        for (MuleCoreExtension extension : this.coreExtensions) {
            if (!this.initializedCoreExtensions.contains(extension)) continue;
            try {
                extension.dispose();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Core extension '{}' disposed", (Object)extension.toString());
            }
            catch (Exception ex) {
                LOGGER.error("Error disposing core extension " + extension.getName(), (Throwable)ex);
            }
        }
        this.initializedCoreExtensions.clear();
    }

    public void initialise() throws InitialisationException {
        try {
            this.coreExtensions = this.coreExtensionDiscoverer.discover();
            this.orderedCoreExtensions = this.coreExtensionDependencyResolver.resolveDependencies(this.coreExtensions);
            this.initializeCoreExtensions();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting core extensions");
        }
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            extension.start();
            this.startedCoreExtensions.add(extension);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Core extension '{}' started", (Object)extension.toString());
        }
    }

    public void stop() throws MuleException {
        if (this.orderedCoreExtensions == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stopping core extensions");
        }
        for (int i = this.orderedCoreExtensions.size() - 1; i >= 0; --i) {
            MuleCoreExtension extension = this.orderedCoreExtensions.get(i);
            if (!this.startedCoreExtensions.contains(extension)) continue;
            try {
                extension.stop();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Core extension '{}' stopped", (Object)extension.toString());
                continue;
            }
            catch (Throwable e) {
                LOGGER.warn("Error stopping core extension: " + extension.getName(), e);
            }
        }
        this.startedCoreExtensions.clear();
    }

    private void initializeCoreExtensions() throws MuleException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initializing core extensions");
        }
        Injector simpleRegistry = this.createContainerInjector();
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            if (extension instanceof DeploymentServiceAware) {
                ((DeploymentServiceAware)extension).setDeploymentService(this.deploymentService);
            }
            if (extension instanceof RepositoryServiceAware) {
                ((RepositoryServiceAware)extension).setRepositoryService(this.repositoryService);
            }
            if (extension instanceof ToolingServiceAware) {
                ((ToolingServiceAware)extension).setToolingService(this.toolingService);
            }
            if (extension instanceof ArtifactDeploymentListener) {
                this.deploymentService.addDeploymentListener(this.createDeploymentListenerAdapter((ArtifactDeploymentListener)extension, ArtifactType.APP));
                this.deploymentService.addDomainDeploymentListener(this.createDeploymentListenerAdapter((ArtifactDeploymentListener)extension, ArtifactType.DOMAIN));
            }
            if (extension instanceof DeploymentListener) {
                this.deploymentService.addDeploymentListener((DeploymentListener)extension);
            }
            if (extension instanceof CoreExtensionsAware) {
                ((CoreExtensionsAware)extension).setCoreExtensions(this.orderedCoreExtensions);
            }
            if (extension instanceof ArtifactClassLoaderManagerAware) {
                ((ArtifactClassLoaderManagerAware)extension).setArtifactClassLoaderManager(this.artifactClassLoaderManager);
            }
            simpleRegistry.inject((Object)extension);
            extension.initialise();
            this.initializedCoreExtensions.add(extension);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Core extension '{}' initialized", (Object)extension.toString());
        }
    }

    private Injector createContainerInjector() {
        return ((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)new ContainerInjectorBuilder().withDeploymentService(this.deploymentService)).withTroubleshootingService(this.troubleshootingService)).withRepositoryService(this.repositoryService)).withServiceRepository(this.serviceRepository)).withCoreExtensions(this.coreExtensions)).withArtifactClassLoaderManager(this.artifactClassLoaderManager)).withEventContextService(this.eventContextService)).withToolingService(this.toolingService)).withServerLockFactory(this.serverLockFactory)).build();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    public void setArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.artifactClassLoaderManager = artifactClassLoaderManager;
    }

    @Override
    public void setEventContextService(EventContextService eventContextService) {
        this.eventContextService = eventContextService;
    }

    @Override
    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    public void setTroubleshootingService(TroubleshootingService troubleshootingService) {
        this.troubleshootingService = troubleshootingService;
    }

    @Override
    public void setServerLockFactory(ServerLockFactory serverLockFactory) {
        this.serverLockFactory = serverLockFactory;
    }

    DeploymentListener createDeploymentListenerAdapter(ArtifactDeploymentListener artifactDeploymentListener, ArtifactType type) {
        return new DeploymentListenerAdapter(artifactDeploymentListener, type);
    }
}

