/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.message.MessageFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.DispatchingLogger;
import org.mule.runtime.module.launcher.log4j2.RecursiveLoggerContextInstantiationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@Feature(value="Core Components")
@Story(value="Logger")
public class DispatchingLoggerTestCase
extends AbstractMuleTestCase {
    private static final String LOGGER_NAME = DispatchingLoggerTestCase.class.getName();
    private static final String MESSAGE = "Hello Log!";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private ClassLoader currentClassLoader;
    @Mock
    private ClassLoader additionalClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Logger originalLogger;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private LoggerContext containerLoggerContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ContextSelector contextSelector;
    @Mock
    private ArtifactAwareContextSelector artifactAwareContextSelector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageFactory messageFactory;
    @Mock
    RegionClassLoader regionClassLoader;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    LoggerContext regionClassLoaderLoggerContext;
    private Logger logger;

    @Before
    public void before() {
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
        Mockito.when((Object)this.containerLoggerContext.getConfiguration().getLoggerConfig(ArgumentMatchers.anyString()).getLevel()).thenReturn((Object)Level.INFO);
        this.logger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, this.contextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
    }

    @Test
    public void currentClassLoader() {
        this.logger.info(MESSAGE);
        ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
    }

    @Test
    public void anotherClassLoader() {
        ClassUtils.withContextClassLoader((ClassLoader)this.additionalClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((Logger)Mockito.verify((Object)this.originalLogger)).info(MESSAGE);
        });
    }

    @Test
    public void regionClassLoader() {
        RegionClassLoader regionClassLoader = (RegionClassLoader)Mockito.mock(RegionClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)regionClassLoader, () -> {
            this.logger.info(MESSAGE);
            ((ContextSelector)Mockito.verify((Object)this.contextSelector)).getContext(LOGGER_NAME, (ClassLoader)regionClassLoader, true);
        });
    }

    @Test
    public void whenRecursiveLoggerContextInstantiationExceptionExpectFallbackUsingContainerClassLoader() {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader(this.currentClassLoader)).thenAnswer(invocation -> this.containerLoggerContext);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)this.regionClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.regionClassLoaderLoggerContext);
        DispatchingLogger dispatchingLogger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, (ContextSelector)this.artifactAwareContextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> {
            dispatchingLogger.info("Fallback Test Message");
            dispatchingLogger.info("Test Message");
        });
        ((Logger)Mockito.verify((Object)containerLogger, (VerificationMode)Mockito.times((int)1))).info("Fallback Test Message");
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info("Test Message");
    }

    @Test
    public void whenFallbackToContainerClassLoaderFailsReturnOriginalLogger() {
        Logger containerLogger = (Logger)Mockito.mock(Logger.class);
        Logger regionClassLoaderLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)this.containerLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)containerLogger);
        Mockito.when((Object)this.regionClassLoaderLoggerContext.getLogger(ArgumentMatchers.anyString(), (MessageFactory)ArgumentMatchers.any(MessageFactory.class))).thenReturn((Object)regionClassLoaderLogger);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader(this.currentClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.containerLoggerContext);
        Mockito.when((Object)this.artifactAwareContextSelector.getContextWithResolvedContextClassLoader((ClassLoader)this.regionClassLoader)).thenThrow(RecursiveLoggerContextInstantiationException.class).thenAnswer(invocation -> this.regionClassLoaderLoggerContext);
        DispatchingLogger dispatchingLogger = new DispatchingLogger(this.originalLogger, this.currentClassLoader.hashCode(), this.containerLoggerContext, (ContextSelector)this.artifactAwareContextSelector, this.messageFactory){

            public String getName() {
                return LOGGER_NAME;
            }
        };
        ClassUtils.withContextClassLoader((ClassLoader)this.regionClassLoader, () -> {
            dispatchingLogger.info("Fallback Test Message");
            dispatchingLogger.info("Test Message");
        });
        ((Logger)Mockito.verify((Object)this.originalLogger, (VerificationMode)Mockito.times((int)1))).info("Fallback Test Message");
        ((Logger)Mockito.verify((Object)regionClassLoaderLogger, (VerificationMode)Mockito.times((int)1))).info("Test Message");
    }
}

