/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.net.URI;
import java.util.List;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.status.StatusLogger;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.launcher.log4j2.LoggerContextCache;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContextFactory;

class ArtifactAwareContextSelector
implements ContextSelector,
Disposable {
    static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final ClassLoader SYSTEM_CLASSLOADER = ClassLoader.getSystemClassLoader();
    private final MuleLoggerContextFactory loggerContextFactory = new MuleLoggerContextFactory();
    private LoggerContextCache cache = new LoggerContextCache(this, this.getClass().getClassLoader());
    private static final LoadingCache<ClassLoader, ClassLoader> classLoaderLoggerCache = Caffeine.newBuilder().weakKeys().weakValues().build(key -> ArtifactAwareContextSelector.getLoggerClassLoader(key));

    ArtifactAwareContextSelector() {
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.getContext(fqcn, loader, currentContext, null);
    }

    public LoggerContext getContext(String fqcn, ClassLoader classLoader, boolean currentContext, URI configLocation) {
        return this.cache.getLoggerContext(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(classLoader));
    }

    LoggerContext getContextWithResolvedContextClassLoader(ClassLoader resolvedContextClassLoader) {
        return this.cache.getLoggerContext(resolvedContextClassLoader);
    }

    public List<LoggerContext> getLoggerContexts() {
        return this.cache.getAllLoggerContexts();
    }

    public void removeContext(LoggerContext context) {
        this.cache.remove(context);
    }

    static ClassLoader resolveLoggerContextClassLoader(ClassLoader classLoader) {
        return (ClassLoader)classLoaderLoggerCache.get((Object)(classLoader == null ? ArtifactAwareContextSelector.resolveTcclOrSystemCl() : classLoader));
    }

    protected static ClassLoader resolveTcclOrSystemCl() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? SYSTEM_CLASSLOADER : tccl;
    }

    private static ClassLoader getLoggerClassLoader(ClassLoader loggerClassLoader) {
        if (loggerClassLoader instanceof CompositeClassLoader) {
            return ArtifactAwareContextSelector.getLoggerClassLoader((ClassLoader)((CompositeClassLoader)loggerClassLoader).getDelegates().get(0));
        }
        while (!(loggerClassLoader instanceof ArtifactClassLoader) && loggerClassLoader != null) {
            loggerClassLoader = loggerClassLoader.getParent();
        }
        if (loggerClassLoader == null) {
            loggerClassLoader = SYSTEM_CLASSLOADER;
        } else if (ArtifactAwareContextSelector.isRegionClassLoaderMember(loggerClassLoader)) {
            loggerClassLoader = ArtifactAwareContextSelector.isPolicyClassLoader(loggerClassLoader.getParent()) ? loggerClassLoader.getParent().getParent() : loggerClassLoader.getParent();
        } else if (!(loggerClassLoader instanceof RegionClassLoader) && !(loggerClassLoader instanceof MuleSharedDomainClassLoader)) {
            loggerClassLoader = SYSTEM_CLASSLOADER;
        }
        return loggerClassLoader;
    }

    private static boolean isPolicyClassLoader(ClassLoader loggerClassLoader) {
        return ((ArtifactClassLoader)loggerClassLoader).getArtifactDescriptor() instanceof PolicyTemplateDescriptor;
    }

    private static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !(classLoader instanceof RegionClassLoader) && classLoader.getParent() instanceof RegionClassLoader;
    }

    public void dispose() {
        this.cache.dispose();
    }

    public void destroyLoggersFor(ClassLoader classLoader) {
        this.cache.remove(classLoader);
    }

    LoggerContext buildContext(ClassLoader classLoader) {
        return this.loggerContextFactory.build(classLoader, this, true);
    }
}

