/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.launcher.coreextension.ClasspathMuleCoreExtensionDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ClasspathMuleCoreExtensionDiscovererTestCase
extends AbstractMuleTestCase {
    @Test
    public void setsContainerClassLoaderOnDiscoveredExtensions() throws Exception {
        ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        ClassLoader classLoader = new ClassLoader(){

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                if (name.equals("META-INF/org/mule/runtime/core/config/core-extensions.properties")) {
                    URL resource = this.getClass().getClassLoader().getResource("test-core-extension.properties");
                    return Collections.enumeration(Collections.singleton(resource));
                }
                return super.getResources(name);
            }
        };
        Mockito.when((Object)artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        ClasspathMuleCoreExtensionDiscoverer discoverer = new ClasspathMuleCoreExtensionDiscoverer(artifactClassLoader);
        List discover = (List)ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoader.getClassLoader(), () -> {
            try {
                return discoverer.discover();
            }
            catch (DefaultMuleException e) {
                throw new IllegalStateException(e);
            }
        });
        MatcherAssert.assertThat((Object)discover, (Matcher)IsIterableWithSize.iterableWithSize((int)2));
        MatcherAssert.assertThat((Object)((MuleCoreExtension)discover.get(0)), (Matcher)IsInstanceOf.instanceOf(PrioritizedTestCoreExtension.class));
        MatcherAssert.assertThat((Object)((MuleCoreExtension)discover.get(1)), (Matcher)IsInstanceOf.instanceOf(TestCoreExtension.class));
        MatcherAssert.assertThat((Object)((TestCoreExtension)discover.get((int)1)).containerClassLoader, (Matcher)CoreMatchers.is((Object)artifactClassLoader));
    }

    public static class PrioritizedTestCoreExtension
    extends TestCoreExtension {
        public int priority() {
            return 0;
        }
    }

    public static class TestCoreExtension
    implements MuleCoreExtension {
        private ArtifactClassLoader containerClassLoader;

        public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
            this.containerClassLoader = containerClassLoader;
        }

        public String getName() {
            return null;
        }

        public void dispose() {
        }

        public void initialise() throws InitialisationException {
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }
    }
}

