/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.container.api.MuleCoreExtensionDependency;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.launcher.coreextension.LinkedMuleCoreExtensionDependency;
import org.mule.runtime.module.launcher.coreextension.ReflectionMuleCoreExtensionDependencyDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ReflectionMuleCoreExtensionDependencyDiscovererTestCase
extends AbstractMuleTestCase {
    private ReflectionMuleCoreExtensionDependencyDiscoverer dependencyDiscoverer = new ReflectionMuleCoreExtensionDependencyDiscoverer();

    @Test
    public void resolvesEmptyDependencies() throws Exception {
        List dependencies = this.dependencyDiscoverer.findDependencies((MuleCoreExtension)new TestCoreExtension());
        Assert.assertThat((Object)dependencies.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void resolvesSingleDependency() throws Exception {
        List dependencies = this.dependencyDiscoverer.findDependencies((MuleCoreExtension)new DependantTestCoreExtension());
        Assert.assertThat((Object)dependencies.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((LinkedMuleCoreExtensionDependency)dependencies.get(0)).getDependencyClass(), (Matcher)CoreMatchers.equalTo(TestCoreExtension.class));
        Assert.assertThat((Object)((LinkedMuleCoreExtensionDependency)dependencies.get(0)).getDependantMethod().getName(), (Matcher)CoreMatchers.equalTo((Object)"setTestCoreExtension"));
    }

    public static class TestCoreExtension
    extends AbstractTestCoreExtension {
    }

    public static class DependantTestCoreExtension
    extends AbstractTestCoreExtension {
        @MuleCoreExtensionDependency
        public void setTestCoreExtension(TestCoreExtension coreExtension) {
        }
    }

    public static class AbstractTestCoreExtension
    implements MuleCoreExtension {
        public void dispose() {
        }

        public void initialise() throws InitialisationException {
        }

        public String getName() {
            return null;
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }

        public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
        }
    }
}

