/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.EnumerationAdapter;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.launcher.coreextension.ClasspathMuleCoreExtensionDiscoverer;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ClasspathMuleCoreExtensionDiscovererTestCase
extends AbstractMuleTestCase {
    @Test
    public void setsContainerClassLoaderOnDiscoveredExtensions() throws Exception {
        ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)Mockito.mock(ArtifactClassLoader.class);
        ClassLoader classLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("test-core-extension.properties");
        Mockito.when(classLoader.getResources("META-INF/org/mule/runtime/core/config/core-extensions.properties")).thenReturn((Object)new EnumerationAdapter(Collections.singleton(resource)));
        Mockito.when((Object)artifactClassLoader.getClassLoader()).thenReturn((Object)classLoader);
        ClasspathMuleCoreExtensionDiscoverer discoverer = new ClasspathMuleCoreExtensionDiscoverer(artifactClassLoader);
        List discover = (List)ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoader.getClassLoader(), () -> {
            try {
                return discoverer.discover();
            }
            catch (DefaultMuleException e) {
                throw new IllegalStateException(e);
            }
        });
        Assert.assertThat((Object)discover.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat(discover.get(0), (Matcher)IsInstanceOf.instanceOf(TestCoreExtension.class));
        Assert.assertThat((Object)((TestCoreExtension)discover.get(0)).containerClassLoader, (Matcher)CoreMatchers.is((Object)artifactClassLoader));
    }

    public static class TestCoreExtension
    implements MuleCoreExtension {
        private ArtifactClassLoader containerClassLoader;

        public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
            this.containerClassLoader = containerClassLoader;
        }

        public String getName() {
            return null;
        }

        public void dispose() {
        }

        public void initialise() throws InitialisationException {
        }

        public void start() throws MuleException {
        }

        public void stop() throws MuleException {
        }
    }
}

