/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.builders;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.RegistryBootstrap;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.internal.alert.DefaultAlertingSupport;
import org.mule.runtime.core.internal.cluster.DefaultClusterService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.DefaultArtifactEncoding;
import org.mule.runtime.core.internal.config.DefaultResourceLocator;
import org.mule.runtime.core.internal.config.InternalCustomizationService;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.connection.DefaultConnectivityTesterFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.core.internal.profiling.EmptySpanExporterConfiguration;
import org.mule.runtime.core.internal.profiling.NoOpProfilingService;
import org.mule.runtime.core.internal.profiling.NoopCoreEventTracer;
import org.mule.runtime.core.internal.profiling.NoopSpanExporterFactory;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.internal.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DefaultTransformersRegistry;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.transformer.ExtendedTransformationService;
import org.mule.runtime.core.internal.transformer.TransformersRegistry;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.queue.wrapper.LocalQueueManagerWrapper;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueManagerSdkWrapper;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueManagerWrapper;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.internal.memory.management.DefaultMemoryManagementService;
import org.mule.runtime.metrics.api.MeterProvider;
import org.mule.runtime.metrics.api.error.ErrorMetricsFactory;
import org.mule.runtime.tracer.api.EventTracer;

public class MinimalConfigurationBuilder
extends AbstractConfigurationBuilder {
    private final Set<String> registeredServices = new HashSet<String>();

    protected void doConfigure(MuleContext muleContext) throws Exception {
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        MuleRegistry registry = ((MuleContextWithRegistry)muleContext).getRegistry();
        RegistryBootstrap.defaultRegistryBoostrap((ArtifactType)ArtifactType.APP, (BootstrapServiceDiscoverer)muleContext.getRegistryBootstrapServiceDiscoverer(), (n, o) -> this.registerObject(n, o, muleContext)).initialise();
        this.configureQueueManager(muleContext);
        registry.registerObject("_muleContext", (Object)muleContext);
        registry.registerObject("_muleConfiguration", (Object)muleContext.getConfiguration());
        this.registerCustomServices(muleContext);
        this.registerObjectStoreManager(muleContext);
        this.registerSchedulerPoolsConfig(muleContext);
        this.registerLockFactory(muleContext);
        this.registerTransformerRegistry(muleContext);
        this.registerExpressionManager(muleContext, registry);
        this.registerObject("_muleArtifactEncoding", new DefaultArtifactEncoding(muleContext.getConfiguration().getDefaultEncoding()), muleContext);
        this.registerConnectionManager(muleContext);
        this.registerNotificationHandlingObjects(muleContext);
        this.registerConnectivityTester(muleContext);
        this.registerInterceptionApiObjects(muleContext);
        this.registerObject("_muleSecurityManager", new DefaultMuleSecurityManager(), muleContext);
        this.registerObject("_muleMemoryManagementService", DefaultMemoryManagementService.getInstance(), muleContext);
        this.registerObject("_muleStreamCloserService", new DefaultStreamCloserService(), muleContext);
        this.registerObject("_muleDefaultObjectSerializer", new JavaObjectSerializer(muleContext.getExecutionClassLoader()), muleContext);
        ContributedErrorTypeRepository contributedErrorTypeRepository = new ContributedErrorTypeRepository();
        this.registerObject(ErrorTypeRepository.class.getName(), contributedErrorTypeRepository, muleContext);
        ContributedErrorTypeLocator contributedErrorTypeLocator = new ContributedErrorTypeLocator();
        contributedErrorTypeLocator.setDelegate(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)contributedErrorTypeRepository));
        this.registerObject(ErrorTypeLocator.class.getName(), contributedErrorTypeLocator, muleContext);
        if (((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("_muleProfilingService") == null) {
            this.registerObject("_muleProfilingService", new NoOpProfilingService(), muleContext);
        }
        this.registerObject("_muleStreamingGhostBuster", new StreamingGhostBuster(), muleContext);
        this.registerStreamingManager(muleContext);
        this.registerObject("_muleTimeSupplier", new LocalTimeSupplier(), muleContext);
        this.registerObject("_muleAlertingSupport", new DefaultAlertingSupport(), muleContext);
        this.registerObject("_muleClusterService", new DefaultClusterService(), muleContext);
        this.registerTransactionFactoryLocator(muleContext);
        this.configureCoreTracer(muleContext);
        this.configureComponentTracerFactory(muleContext);
        this.configureSpanExporterConfiguration(muleContext);
        this.configureSpanExporterFactory(muleContext);
        this.configureErrorMetricsFactory(muleContext);
        this.configureBaseArtifactMeterProvider(muleContext);
        this.registerObject("_muleComponentInitialStateManager", new ComponentInitialStateManager(){

            public boolean mustStartMessageSource(Component component) {
                return true;
            }
        }, muleContext);
        this.registerObject("_muleResourceLocator", new DefaultResourceLocator(), muleContext);
        for (String serviceId : ((InternalCustomizationService)muleContext.getCustomizationService()).getDefaultServices().keySet()) {
            if (this.registeredServices.contains(serviceId)) continue;
            this.registerObject(serviceId, null, muleContext);
        }
    }

    protected void configureBaseArtifactMeterProvider(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleMeterProvider", MeterProvider.NO_OP, muleContext);
    }

    protected void configureErrorMetricsFactory(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleErrorMetricsFactory", ErrorMetricsFactory.NO_OP, muleContext);
    }

    protected void registerTransactionFactoryLocator(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleTransactionFactoryLocator", new TransactionFactoryLocator(), muleContext);
    }

    protected void registerStreamingManager(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleStreamingManager", new DefaultStreamingManager(), muleContext);
    }

    protected void registerInterceptionApiObjects(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleInterceptorManager", new DefaultProcessorInterceptorManager(), muleContext);
    }

    protected void registerConnectivityTester(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleConnectivityTesterFactory", new DefaultConnectivityTesterFactory(), muleContext);
    }

    protected void registerConnectionManager(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleConnectionManager", new DefaultConnectionManager(muleContext), muleContext);
    }

    protected void registerNotificationHandlingObjects(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleNotificationDispatcher", new DefaultNotificationDispatcher(), muleContext);
        this.registerObject("_muleNotificationListenerRegistry", new DefaultNotificationListenerRegistry(), muleContext);
    }

    protected void registerExpressionManager(MuleContext muleContext, MuleRegistry registry) throws MuleException {
        this.registerObject("_muleExpressionManager", this.getExpressionManager(muleContext, registry), muleContext);
    }

    protected ExtendedExpressionManager getExpressionManager(MuleContext muleContext, MuleRegistry registry) throws MuleException {
        DefaultExpressionManager expressionManager = new DefaultExpressionManager();
        DefaultExpressionLanguageFactoryService service = this.getExpressionLanguageFactoryService(registry);
        ArtifactEncoding artifactEncoding = this.getArtifactEncoding(registry);
        expressionManager.setExpressionLanguage((ExtendedExpressionLanguageAdaptor)new DataWeaveExpressionLanguageAdaptor(muleContext, null, muleContext.getConfiguration(), artifactEncoding, service, null));
        muleContext.getInjector().inject((Object)expressionManager);
        return expressionManager;
    }

    protected DefaultExpressionLanguageFactoryService getExpressionLanguageFactoryService(MuleRegistry registry) throws RegistrationException {
        return (DefaultExpressionLanguageFactoryService)registry.lookupObject(DefaultExpressionLanguageFactoryService.class);
    }

    protected ArtifactEncoding getArtifactEncoding(MuleRegistry registry) throws RegistrationException {
        return (ArtifactEncoding)registry.lookupObject(ArtifactEncoding.class);
    }

    protected void registerTransformerRegistry(MuleContext muleContext) throws RegistrationException {
        DefaultTransformersRegistry transformersRegistry = new DefaultTransformersRegistry();
        this.registerObject("_muleTransfromersRegistry", transformersRegistry, muleContext);
        this.registerObject("_converterResolver", new DynamicDataTypeConversionResolver((TransformersRegistry)transformersRegistry), muleContext);
        this.registerObject("_muleTransformationService", new ExtendedTransformationService(), muleContext);
        this.registerObject("_muleTransfromerResolver", new TypeBasedTransformerResolver(), muleContext);
    }

    protected void registerLockFactory(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleLockProvider", new SingleServerLockProvider(), muleContext);
        this.registerObject("_muleLockFactory", new MuleLockFactory(), muleContext);
    }

    protected void registerSchedulerPoolsConfig(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleSchedulerPoolsConfig", SchedulerContainerPoolsConfig.getInstance(), muleContext);
        this.registerObject("_muleSchedulerBaseConfig", SchedulerConfig.config().withPrefix(muleContext.getConfiguration().getId()).withShutdownTimeout(() -> muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS), muleContext);
    }

    protected void registerCustomServices(MuleContext muleContext) {
        for (Map.Entry entry : ((InternalCustomizationService)muleContext.getCustomizationService()).getCustomServices().entrySet()) {
            ((CustomService)entry.getValue()).getServiceImpl().ifPresent(s -> {
                try {
                    this.registerObject((String)entry.getKey(), s, muleContext);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
        }
    }

    protected <T> void registerObject(String serviceId, T defaultServiceImpl, MuleContext muleContext) throws RegistrationException {
        this.registeredServices.add(serviceId);
        Optional<T> serviceImpl = ((InternalCustomizationService)muleContext.getCustomizationService()).getOverriddenService(serviceId).map(customService -> customService.getServiceImpl(defaultServiceImpl)).orElse(Optional.ofNullable(defaultServiceImpl));
        if (!serviceImpl.isPresent()) {
            return;
        }
        T service = serviceImpl.orElseThrow();
        try {
            muleContext.getInjector().inject(service);
        }
        catch (MuleException e) {
            throw new RegistrationException((Throwable)e);
        }
        if (service instanceof MuleContextAware) {
            ((MuleContextAware)service).setMuleContext(muleContext);
        }
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject(serviceId, service);
    }

    protected void registerObjectStoreManager(MuleContext muleContext) throws RegistrationException {
        this.registerObjectStorePartitions(muleContext);
        MuleObjectStoreManager osm = new MuleObjectStoreManager();
        osm.setBasePersistentStoreKey("_defaultPersistentObjectStore");
        osm.setBaseTransientStoreKey("_defaultInMemoryObjectStore");
        osm.setSchedulerConfig(SchedulerConfig::config);
        this.registerObject("_muleObjectStoreManager", osm, muleContext);
    }

    protected void registerObjectStorePartitions(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_defaultInMemoryObjectStore", this.getDefaultInMemoryObjectStore(), muleContext);
        this.registerObject("_defaultPersistentObjectStore", this.getDefaultPersistentObjectStore(), muleContext);
    }

    protected ObjectStore<Serializable> getDefaultPersistentObjectStore() {
        return DefaultObjectStoreFactoryBean.createDefaultPersistentObjectStore();
    }

    protected ObjectStore<Serializable> getDefaultInMemoryObjectStore() {
        return DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore();
    }

    protected void configureQueueManager(MuleContext muleContext) throws RegistrationException {
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        queueManager.setMuleConfiguration(muleContext.getConfiguration());
        queueManager.setMuleContext(muleContext);
        QueueManagerWrapper wrapperQueueManager = new QueueManagerWrapper();
        wrapperQueueManager.setQueueManager((QueueManager)queueManager);
        QueueManagerSdkWrapper sdkWrapperQueueManager = new QueueManagerSdkWrapper();
        sdkWrapperQueueManager.setQueueManager((QueueManager)queueManager);
        this.registerObject("_muleApiQueueManager", queueManager, muleContext);
        this.registerObject("_muleSdkApiQueueManager", sdkWrapperQueueManager, muleContext);
        this.registerObject("_muleQueueManager", wrapperQueueManager, muleContext);
        this.registerObject("_localQueueManager", new LocalQueueManagerWrapper(), muleContext);
    }

    private void configureComponentTracerFactory(MuleContext muleContext) throws RegistrationException {
        DummyComponentTracerFactory componentTracerFactory = DummyComponentTracerFactory.getDummyComponentTracerFactory();
        this.registerObject("_muleCoreComponentTracerFactory", componentTracerFactory, muleContext);
    }

    protected void configureCoreTracer(MuleContext muleContext) throws RegistrationException {
        EventTracer tracer = NoopCoreEventTracer.getNoopCoreEventTracer();
        this.registerObject("_muleCoreEventTracer", tracer, muleContext);
    }

    protected void configureSpanExporterFactory(MuleContext muleContext) throws RegistrationException {
        NoopSpanExporterFactory spanExporterFactory = new NoopSpanExporterFactory();
        this.registerObject("_muleCoreExporterFactory", spanExporterFactory, muleContext);
    }

    protected void configureSpanExporterConfiguration(MuleContext muleContext) throws RegistrationException {
        this.registerObject("_muleSpanExporterConfiguration", new EmptySpanExporterConfiguration(), muleContext);
    }
}

