/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.petstore.extension.PetStoreClient;

public class ModuleTlsEnabledTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    @Override
    protected String[] getModulePaths() {
        return new String[]{"modules/module-tls-config.xml", "modules/module-tls-config-with-default.xml", "modules/module-tls-config-required.xml", "modules/module-tls-config-required-with-default.xml"};
    }

    protected String getConfigFile() {
        return "flows/flows-using-module-tls-config.xml";
    }

    @Override
    protected boolean shouldValidateXml() {
        return true;
    }

    @Test
    public void noTlsContextProvided() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientNoTls").getMessage().getPayload().getValue();
        Assert.assertThat((Object)client.getTlsContext(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void whenInnerConfigDoesNotEnableTlsThenItIsNotMacroExpanded() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientNoCustomTlsSupport").getMessage().getPayload().getValue();
        Assert.assertThat((Object)client.getTlsContext(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void tlsContextByRef() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientByRef").getMessage().getPayload().getValue();
        this.assertExpectedTlsContext(client.getTlsContext());
    }

    @Test
    public void tlsContextInline() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientInline").getMessage().getPayload().getValue();
        this.assertExpectedTlsContext(client.getTlsContext());
    }

    @Test
    public void tlsContextRequired() throws Exception {
        HeisenbergConnection connection = (HeisenbergConnection)this.runFlow("getHeisenbergConnectionRequiredByRef").getMessage().getPayload().getValue();
        this.assertExpectedTlsContext(connection.getTlsContextFactory());
    }

    @Test
    public void noCustomTlsButDefaultFromModule() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientWithDefault").getMessage().getPayload().getValue();
        TlsContextFactory actualTlsContextFactory = client.getTlsContext();
        Assert.assertThat((Object)actualTlsContextFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getPassword(), (Matcher)CoreMatchers.is((Object)"changeit2"));
    }

    @Test
    public void whenCustomTlsIsProvidedToTlsEnabledThenItTakesPrecedence() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientWithDefaultByRef").getMessage().getPayload().getValue();
        this.assertExpectedTlsContext(client.getTlsContext());
    }

    @Test
    public void whenInnerConfigDoesNotEnableTlsAndHasDefaultThenDefaultTakesPrecedence() throws Exception {
        PetStoreClient client = (PetStoreClient)this.runFlow("getPetStoreClientFixedTls").getMessage().getPayload().getValue();
        TlsContextFactory actualTlsContextFactory = client.getTlsContext();
        Assert.assertThat((Object)actualTlsContextFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getPassword(), (Matcher)CoreMatchers.is((Object)"changeit2"));
    }

    @Test
    public void whenInnerConfigRequiresTlsButProvidesOneThenBecomesOptional() throws Exception {
        HeisenbergConnection connection = (HeisenbergConnection)this.runFlow("getHeisenbergConnectionRequiredWithDefaultNoTls").getMessage().getPayload().getValue();
        TlsContextFactory actualTlsContextFactory = connection.getTlsContextFactory();
        Assert.assertThat((Object)actualTlsContextFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getPassword(), (Matcher)CoreMatchers.is((Object)"changeit2"));
    }

    private void assertExpectedTlsContext(TlsContextFactory actualTlsContextFactory) throws IOException {
        String expectedKeyStorePath = FileUtils.getResourcePath((String)"ssltest-keystore.jks", ((Object)((Object)this)).getClass());
        String expectedTrustStorePath = FileUtils.getResourcePath((String)"ssltest-cacerts.jks", ((Object)((Object)this)).getClass());
        Assert.assertThat((Object)actualTlsContextFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualTlsContextFactory.getEnabledProtocols(), (Matcher)CoreMatchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"TLSv1.2"})));
        Assert.assertThat((Object)actualTlsContextFactory.getEnabledCipherSuites(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)actualTlsContextFactory.getKeyStoreConfiguration().getKeyPassword(), (Matcher)CoreMatchers.is((Object)"changeit"));
        Assert.assertThat((Object)actualTlsContextFactory.getKeyStoreConfiguration().getPassword(), (Matcher)CoreMatchers.is((Object)"changeit"));
        Assert.assertThat((Object)actualTlsContextFactory.getKeyStoreConfiguration().getPath(), (Matcher)CoreMatchers.is((Object)expectedKeyStorePath));
        Assert.assertThat((Object)actualTlsContextFactory.getKeyStoreConfiguration().getType(), (Matcher)CoreMatchers.is((Object)KeyStore.getDefaultType()));
        Assert.assertThat((Object)actualTlsContextFactory.getKeyStoreConfiguration().getAlgorithm(), (Matcher)CoreMatchers.is((Object)KeyManagerFactory.getDefaultAlgorithm()));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getPassword(), (Matcher)CoreMatchers.is((Object)"changeit"));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getPath(), (Matcher)CoreMatchers.is((Object)expectedTrustStorePath));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getType(), (Matcher)CoreMatchers.is((Object)KeyStore.getDefaultType()));
        Assert.assertThat((Object)actualTlsContextFactory.getTrustStoreConfiguration().getAlgorithm(), (Matcher)CoreMatchers.is((Object)TrustManagerFactory.getDefaultAlgorithm()));
    }
}

