/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.petstore.extension.PetStoreConnector;

@SmallTest
public class TlsEnabledModelTestCase
extends AbstractMuleTestCase {
    private static final ExtensionModel PET_STORE_EXTENSION_MODEL = MuleExtensionUtils.loadExtension(PetStoreConnector.class);
    private static final ExtensionModel HEISENBERG_EXTENSION_MODEL = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    private static final String EXPECTED_TLS_CONTEXT_PARAM_NAME = "tlsContext";
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void generatedModelHasTlsContextParameter() {
        ExtensionModel extensionModel = this.loadExtensionModelFrom("modules/module-tls-config.xml", Collections.singleton(PET_STORE_EXTENSION_MODEL));
        this.assertModelHasTlsContextParameter(extensionModel, false);
    }

    @Test
    public void whenTargetRequiresTlsContextThenGeneratedModelHasRequiredTlsContextParameter() {
        ExtensionModel extensionModel = this.loadExtensionModelFrom("modules/module-tls-config-required.xml", Collections.singleton(HEISENBERG_EXTENSION_MODEL));
        this.assertModelHasTlsContextParameter(extensionModel, true);
    }

    @Test
    public void whenTargetRequiresTlsContextAndProvidesOneThenGeneratedModelHasOptionalTlsContextParameter() {
        ExtensionModel extensionModel = this.loadExtensionModelFrom("modules/module-tls-config-required-with-default.xml", Collections.singleton(HEISENBERG_EXTENSION_MODEL));
        this.assertModelHasTlsContextParameter(extensionModel, false);
    }

    @Test
    public void multipleElementsWithXmlnsTlsEnabledAttribute() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("There can only be one global element marked with [xmlns:tlsEnabled] but found [2], offending global elements are: [petstore-config, unnamed@module-tls-config/2/connection]");
        this.loadExtensionModelFrom("validation/tls/module-tls-config-multiple-annotated-elems.xml", Collections.singleton(PET_STORE_EXTENSION_MODEL));
    }

    @Test
    public void unsupportedTlsConfigurationTarget() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("The annotated element [unnamed@module-tls-config/2/1/0] with [xmlns:tlsEnabled] is not valid to be configured for TLS (the component [petstore:pet] does not support it)");
        this.loadExtensionModelFrom("validation/tls/module-tls-config-unsupported-target.xml", Collections.singleton(PET_STORE_EXTENSION_MODEL));
    }

    @Test
    public void unsupportedTlsConfigurationTargetOperation() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("The annotated element [set-payload-hardcoded-value] with [xmlns:tlsEnabled] is not valid to be configured for TLS (the component [module:operation] does not support it)");
        this.loadExtensionModelFrom("validation/tls/module-tls-config-unsupported-target-operation.xml", Collections.singleton(PET_STORE_EXTENSION_MODEL));
    }

    @Test
    public void unsupportedTlsConfigurationTargetModule() {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("The annotated element [module-tls-config] with [xmlns:tlsEnabled] is not valid to be configured for TLS (the component [module:module] does not support it)");
        this.loadExtensionModelFrom("validation/tls/module-tls-config-unsupported-target-module.xml", Collections.singleton(PET_STORE_EXTENSION_MODEL));
    }

    private ExtensionModel loadExtensionModelFrom(String modulePath, Set<ExtensionModel> dependencyExtensions) {
        HashSet<ExtensionModel> allExtensions = new HashSet<ExtensionModel>(dependencyExtensions);
        allExtensions.add(MuleExtensionModelProvider.getExtensionModel());
        ExtensionModelLoadingRequest request = ExtensionModelLoadingRequest.builder((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (DslResolvingContext)DslResolvingContext.getDefault(allExtensions)).addParameter("resource-xml", (Object)modulePath).build();
        return new XmlExtensionModelLoader().loadExtensionModel(request);
    }

    private void assertModelHasTlsContextParameter(ExtensionModel extensionModel, boolean expectRequired) {
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModel("config").get();
        ParameterGroupModel defaultParameterGroupModel = configurationModel.getParameterGroupModels().stream().filter(pgm -> pgm.getName().equals("General")).findFirst().get();
        ParameterModel tlsContextParameterModel = (ParameterModel)defaultParameterGroupModel.getParameter(EXPECTED_TLS_CONTEXT_PARAM_NAME).get();
        MatcherAssert.assertThat((Object)((Class)ExtensionMetadataTypeUtils.getType((MetadataType)tlsContextParameterModel.getType()).get()), (Matcher)Is.is(TlsContextFactory.class));
        MatcherAssert.assertThat((Object)ExtensionMetadataTypeUtils.isInfrastructure((MetadataType)tlsContextParameterModel.getType()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)tlsContextParameterModel.isRequired(), (Matcher)Is.is((Object)expectRequired));
        MatcherAssert.assertThat((Object)tlsContextParameterModel.getRole(), (Matcher)Is.is((Object)ParameterRole.BEHAVIOUR));
        MatcherAssert.assertThat((Object)tlsContextParameterModel.getExpressionSupport(), (Matcher)Is.is((Object)ExpressionSupport.NOT_SUPPORTED));
        MatcherAssert.assertThat((Object)tlsContextParameterModel.getModelProperty(SyntheticModelModelProperty.class).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)tlsContextParameterModel.getModelProperty(InfrastructureParameterModelProperty.class).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)tlsContextParameterModel.getModelProperty(QNameModelProperty.class), (Matcher)Is.is((Object)InfrastructureTypeMapping.getQName((String)EXPECTED_TLS_CONTEXT_PARAM_NAME)));
        ParameterDslConfiguration actualDslConfiguration = tlsContextParameterModel.getDslConfiguration();
        ParameterDslConfiguration expectedDslConfiguration = (ParameterDslConfiguration)InfrastructureTypeMapping.getDslConfiguration((String)EXPECTED_TLS_CONTEXT_PARAM_NAME).get();
        MatcherAssert.assertThat((Object)actualDslConfiguration.allowTopLevelDefinition(), (Matcher)Is.is((Object)expectedDslConfiguration.allowTopLevelDefinition()));
        MatcherAssert.assertThat((Object)actualDslConfiguration.allowsReferences(), (Matcher)Is.is((Object)expectedDslConfiguration.allowsReferences()));
        MatcherAssert.assertThat((Object)actualDslConfiguration.allowsInlineDefinition(), (Matcher)Is.is((Object)expectedDslConfiguration.allowsInlineDefinition()));
    }
}

