/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.functional;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.functional.AbstractCeXmlExtensionMuleArtifactFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ModuleCallingOperationsWithinModuleTestCase
extends AbstractCeXmlExtensionMuleArtifactFunctionalTestCase {
    private static final String HARDCODED_VALUE = "hardcoded value";
    private static final String SIMPLE_VARIABLE_VALUE = "some food for this operation";
    private static final String NESTED_MADNESS_EXPECTED = "{op3, we will stop calling operations here (any user calling more than 3 nested operations can go and code it in Java) {op2 breadcrum, we need to go deeper..{op1 breadcrum, we need to go deeper..%s}}}";
    private static final String FIRST_PART = "smart";
    private static final String SECOND_PART = " connector content";
    @Parameterized.Parameter
    public String configFile;
    @Parameterized.Parameter(value=1)
    public String[] paths;
    @Parameterized.Parameter(value=2)
    public boolean shouldValidate;

    @Parameterized.Parameters(name="{index}: Running tests for {0} (validating XML [{2}])")
    public static Collection<Object[]> data() {
        return Arrays.asList(ModuleCallingOperationsWithinModuleTestCase.getSimpleScenario(false), ModuleCallingOperationsWithinModuleTestCase.getSimpleScenario(true), ModuleCallingOperationsWithinModuleTestCase.getNestedModulesScenario(false), ModuleCallingOperationsWithinModuleTestCase.getNestedModulesScenario(true));
    }

    private static Object[] getSimpleScenario(boolean shouldValidate) {
        return new Object[]{"flows/flows-using-module-calling-operations-within-module.xml", new String[]{"modules/module-calling-operations-within-module.xml"}, shouldValidate};
    }

    private static Object[] getNestedModulesScenario(boolean shouldValidate) {
        return new Object[]{"flows/nested/flows-using-module-calling-operations-within-module-proxy.xml", new String[]{"modules/module-calling-operations-within-module.xml", "modules/nested/module-calling-operations-within-module-proxy.xml"}, shouldValidate};
    }

    @Override
    protected String[] getModulePaths() {
        return this.paths;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Override
    protected boolean shouldValidateXml() {
        return this.shouldValidate;
    }

    @Test
    public void testSetPayloadThruInternalSetPayloadHardcodedValue() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruInternalSetPayloadHardcodedValue");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)HARDCODED_VALUE));
    }

    @Test
    public void testSetPayloadThruPublicTnsOperation() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruSetPayloadThruInternalSetPayloadHardcodedValue");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)HARDCODED_VALUE));
    }

    @Test
    public void testSetPayloadThruInternalSetPayloadHardcodedValueTwoTimes() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruInternalSetPayloadHardcodedValueTwoTimes");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)HARDCODED_VALUE));
    }

    @Test
    public void testSetPayloadThruInternalSetPayloadParamValue() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruInternalSetPayloadParamValue");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)SIMPLE_VARIABLE_VALUE));
    }

    @Test
    public void testSetPayloadContentThruInternalSetPayloadParamValue() throws Exception {
        CoreEvent event = this.runFlowWithContentVariable("testSetPayloadContentThruInternalSetPayloadParamValue");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"smart connector content"));
    }

    @Test
    public void testSetPayloadThruInternalSetPayloadUsingContentParameter() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruInternalSetPayloadUsingContentParameter");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)SIMPLE_VARIABLE_VALUE));
    }

    @Test
    public void testSetPayloadContentThruInternalSetPayloadUsingContentParameter() throws Exception {
        CoreEvent event = this.runFlowWithContentVariable("testSetPayloadContentThruInternalSetPayloadUsingContentParameter");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"smart connector content"));
    }

    @Test
    public void testSetPayloadThruInternalSetPayloadUsingContentAndPrimaryAndSimpleParameter() throws Exception {
        CoreEvent event = this.runFlowWithContentAndDefaultVariables("testSetPayloadThruInternalSetPayloadUsingContentAndPrimaryAndSimpleParameter");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)String.format("attribute value:[%s], value of content:[%s], value of primary:[%s]", SIMPLE_VARIABLE_VALUE, FIRST_PART, SECOND_PART)));
    }

    @Test
    public void testSetPayloadThruNestedMadness() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruNestedMadness");
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)String.format(NESTED_MADNESS_EXPECTED, SIMPLE_VARIABLE_VALUE)));
    }

    @Test
    public void testSetPayloadThruNestedMadnessPipingItThreeTimes() throws Exception {
        CoreEvent event = this.runFlowWithDefaultVariable("testSetPayloadThruNestedMadnessPipingItThreeTimes");
        String expected = String.format(NESTED_MADNESS_EXPECTED, String.format(NESTED_MADNESS_EXPECTED, String.format(NESTED_MADNESS_EXPECTED, SIMPLE_VARIABLE_VALUE)));
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testSetPayloadThruNestedMadnessPipingWithForeach() throws Exception {
        int amount = 3;
        CoreEvent event = this.runFlowWithAmountVariable("testSetPayloadThruNestedMadnessPipingWithForeach", 3);
        StringBuilder expected = new StringBuilder();
        for (int i = 1; i <= 3; ++i) {
            expected.append(String.format(NESTED_MADNESS_EXPECTED, String.valueOf(i)));
        }
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)expected.toString()));
    }

    @Test
    public void testSetPayloadThruNestedMadnessPipingWithNestedForeachs() throws Exception {
        int amount = 3;
        CoreEvent event = this.runFlowWithAmountVariable("testSetPayloadThruNestedMadnessPipingWithNestedForeachs", 3);
        StringBuilder expected = new StringBuilder();
        for (int i = 1; i <= 3; ++i) {
            expected.append(String.format(NESTED_MADNESS_EXPECTED, String.valueOf(i)));
            for (int j = 3; j >= 1; --j) {
                expected.append(String.format(NESTED_MADNESS_EXPECTED, String.valueOf(j)));
            }
        }
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)expected.toString()));
    }

    private CoreEvent runFlowWithDefaultVariable(String flowName) throws Exception {
        return ((FlowRunner)this.flowRunner(flowName).withVariable("simpleParameter", (Object)SIMPLE_VARIABLE_VALUE)).run();
    }

    private CoreEvent runFlowWithAmountVariable(String flowName, int amount) throws Exception {
        return ((FlowRunner)this.flowRunner(flowName).withVariable("amount", (Object)amount)).run();
    }

    private CoreEvent runFlowWithContentVariable(String flowName) throws Exception {
        return ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withVariable("firstPart", (Object)FIRST_PART)).withVariable("secondPart", (Object)SECOND_PART)).run();
    }

    private CoreEvent runFlowWithContentAndDefaultVariables(String flowName) throws Exception {
        return ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withVariable("simpleParameter", (Object)SIMPLE_VARIABLE_VALUE)).withVariable("firstPart", (Object)FIRST_PART)).withVariable("secondPart", (Object)SECOND_PART)).run();
    }

    public boolean mustRegenerateComponentBuildingDefinitionRegistryFactory() {
        return true;
    }
}

