/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.ExtensionModelFactory;
import org.mule.runtime.extension.internal.loader.XmlExtensionLoaderDelegate;
import org.mule.runtime.extension.internal.loader.validator.TestConnectionValidator;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ConnectivityTestingFailuresTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void multipleGlobalElementsWithXmlnsConnectionAttribute() {
        this.setExpectedMessage("first-config", "second-config");
        this.getExtensionModelFrom("validation/testconnection/module-multiple-global-element-xmlns-connection-true.xml", new HashSet<ExtensionModel>(Arrays.asList(this.getPetstoreExtension(true))));
    }

    @Test
    public void multipleGlobalElementsWithTestConnectionAndNotEvenOneDefined() {
        this.setExpectedMessage("first-config-not-defined-to-which-one-do-test-connection", "second-config-not-defined-to-which-one-do-test-connection");
        this.getExtensionModelFrom("validation/testconnection/module-not-defined-test-connection.xml", new HashSet<ExtensionModel>(Arrays.asList(this.getPetstoreExtension(true))));
    }

    @Test
    public void multipleGlobalElementsWithTestConnectionAndNotEvenOneDefinedHttpAndFile() {
        this.setExpectedMessage("file-global-element", "http-global-element");
        this.getExtensionModelFrom("validation/testconnection/module-not-defined-test-connection-http-file.xml", new HashSet<ExtensionModel>(Arrays.asList(this.getPetstoreExtension(true), this.getFileExtension())));
    }

    @Test
    public void repeatedPropertiesConfigurationConnection() {
        this.setExpectedMessage("repeated properties are: [someUserConfig, somePassConfig]");
        this.getExtensionModelFrom("validation/testconnection/module-repeated-properties-configuration-connection.xml");
    }

    @Test
    public void multipleConnectionProperties() {
        this.setExpectedMessage("There cannot be more than 1 child [connection] element per [module], found [2]");
        this.getExtensionModelFrom("validation/testconnection/module-multiple-connection.xml");
    }

    @Test
    public void invalidTestConnectionElement() {
        ExtensionModel loaded = this.getExtensionModelFrom("validation/testconnection/module-invalid-test-connection.xml", new HashSet<ExtensionModel>(Arrays.asList(this.getPetstoreExtension(false))));
        ProblemsReporter problemsReporter = new ProblemsReporter(loaded);
        new TestConnectionValidator().validate(loaded, problemsReporter);
        MatcherAssert.assertThat((Object)problemsReporter.getWarnings().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Problem)problemsReporter.getWarnings().get(0)).getMessage(), (Matcher)Matchers.is((Object)String.format("The annotated element [%s] with [%s] is not valid to be used as a test connection (the [%s] does not supports it)", "http-requester-config", XmlExtensionLoaderDelegate.MODULE_CONNECTION_MARKER_ANNOTATION_ATTRIBUTE, "petstore:config")));
        MatcherAssert.assertThat((Object)((Problem)problemsReporter.getWarnings().get(0)).getComponent(), (Matcher)Matchers.is(loaded.getConfigurationModels().get(0)));
    }

    private ExtensionModel getFileExtension() {
        return this.mockedExtension("file", "config", "connection", true);
    }

    private ExtensionModel getPetstoreExtension(boolean supportsConnectivityTesting) {
        return this.mockedExtension("petstore", "config", "connection", supportsConnectivityTesting);
    }

    private void setExpectedMessage(String ... conflictingGlobalElements) {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage(Arrays.stream(conflictingGlobalElements).collect(Collectors.joining(", ")));
    }

    private ExtensionModel mockedExtension(String name, String config, String connectionProvider, boolean supportsConnectivityTesting) {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(ConnectivityTestingFailuresTestCase.class.getClassLoader());
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
        ConfigurationDeclarer configDeclarer = extensionDeclarer.named(name).onVersion("4.0.0").fromVendor("MuleSoft testcase").withCategory(Category.COMMUNITY).withConfig(config);
        configDeclarer.withConnectionProvider(connectionProvider).supportsConnectivityTesting(supportsConnectivityTesting).withConnectionManagementType(ConnectionManagementType.NONE).onDefaultParameterGroup().withRequiredParameter("name").ofType(typeLoader.load(String.class)).asComponentId();
        return new ExtensionModelFactory().create((ExtensionLoadingContext)new DefaultExtensionLoadingContext(extensionDeclarer, Thread.currentThread().getContextClassLoader(), (DslResolvingContext)new NullDslResolvingContext()));
    }

    private ExtensionModel getExtensionModelFrom(String modulePath) {
        return this.getExtensionModelFrom(modulePath, Collections.emptySet());
    }

    private ExtensionModel getExtensionModelFrom(String modulePath, Set<ExtensionModel> depedencyExtensions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource-xml", modulePath);
        parameters.put("COMPILATION_MODE", true);
        HashSet<ExtensionModel> allExtensions = new HashSet<ExtensionModel>(depedencyExtensions);
        allExtensions.add(MuleExtensionModelProvider.getExtensionModel());
        return new XmlExtensionModelLoader().loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(allExtensions), parameters);
    }
}

