/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.loader.xml.XmlExtensionModelLoader;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
public class ModuleSchemaGeneratorTestCase
extends AbstractMuleTestCase {
    @Parameterized.Parameter
    public ExtensionModel extensionModel;
    @Parameterized.Parameter(value=1)
    public String expectedXSD;
    @Parameterized.Parameter(value=2)
    public String extensionName;
    private DefaultExtensionSchemaGenerator extensionSchemaFactory;

    @Parameterized.Parameters(name="{index}: Validating xsd for {2}")
    public static Collection<Object[]> data() {
        Class<ModuleSchemaGeneratorTestCase> classLoader = ModuleSchemaGeneratorTestCase.class;
        ArrayList<String> extensions = new ArrayList<String>(){
            {
                this.add("module-namespace-custom");
                this.add("module-param-default-types");
                this.add("module-param-custom-types");
                this.add("module-param-role");
                this.add("module-param-types");
                this.add("module-properties-default-types");
                this.add("module-properties-types");
                this.add("module-single-op-with-property");
                this.add("module-single-operation");
                this.add("module-single-operation-camelized");
            }
        };
        Function<String, Object[]> stringFunction = moduleName -> {
            String moduleNamePrefix = "modules/schema/" + moduleName;
            String modulePath = moduleNamePrefix + ".xml";
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("resource-xml", modulePath);
            parameters.put("COMPILATION_MODE", true);
            ExtensionModel extensionModel = new XmlExtensionModelLoader().loadExtensionModel(contextClassLoader, DslResolvingContext.getDefault(ModuleSchemaGeneratorTestCase.getDependencies()), parameters);
            try {
                return new Object[]{extensionModel, IOUtils.getResourceAsString((String)(moduleNamePrefix + ".xsd"), (Class)classLoader), extensionModel.getName()};
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Couldn't load .xsd for the [%s] module", moduleName));
            }
        };
        return extensions.stream().map(stringFunction).collect(Collectors.toList());
    }

    private static Set<ExtensionModel> getDependencies() {
        return Collections.singleton(MuleExtensionModelProvider.getExtensionModel());
    }

    @Before
    public void setUp() {
        this.extensionSchemaFactory = new DefaultExtensionSchemaGenerator();
    }

    @Test
    public void generateXsd() throws Exception {
        String generatedSchema = this.extensionSchemaFactory.generate(this.extensionModel, DslResolvingContext.getDefault(Collections.emptySet()));
        this.compareXML(this.expectedXSD, generatedSchema);
    }

    private void compareXML(String expected, String actual) throws Exception {
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)false);
        Diff diff = XMLUnit.compareXML((String)expected, (String)actual);
        if (!diff.similar() || !diff.identical()) {
            System.out.println(actual);
            DetailedDiff detDiff = new DetailedDiff(diff);
            List differences = detDiff.getAllDifferences();
            StringBuilder diffLines = new StringBuilder();
            for (Object object : differences) {
                Difference difference = (Difference)object;
                diffLines.append(difference.toString() + '\n');
            }
            throw new IllegalArgumentException("Actual XML differs from expected: \n" + diffLines.toString());
        }
    }
}

