/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.validator.property.InvalidTestConnectionMarkerModelProperty;

public class TestConnectionValidator
implements ExtensionModelValidator {
    public static final String TEST_CONNECTION_SELECTED_ELEMENT_INVALID = "The annotated element [%s] with [%s] is not valid to be used as a test connection (the [%s] does not supports it)";

    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                model.getModelProperty(InvalidTestConnectionMarkerModelProperty.class).ifPresent(mp -> problemsReporter.addWarning(new Problem((NamedObject)model, String.format(TestConnectionValidator.TEST_CONNECTION_SELECTED_ELEMENT_INVALID, mp.getMarkedElement(), "xmlns:connection", mp.getOffendingElement()))));
            }
        }.walk(extensionModel);
    }
}

