/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.internal.factories;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Supplier;

public class XmlSdkConfigurationFactory implements ConfigurationFactory {

  private final Supplier<Class<?>> configClass;

  private Object lastBuilt;

  public XmlSdkConfigurationFactory(List<ParameterDeclaration> configParamDeclarations) {
    // We don't use the supplier instance directly as the LazyValue argument to avoid the class from being loaded here and defer
    // it to until it is consumed.
    this.configClass = new LazyValue<>(() -> new XmlSdkConfigBeanClassSupplier(configParamDeclarations).get());
  }

  @Override
  public Object newInstance() {
    Object instance;
    try {
      instance = this.configClass.get().getDeclaredConstructor().newInstance();
    } catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
        | NoSuchMethodException | SecurityException e) {
      throw new MuleRuntimeException(e);
    }
    this.lastBuilt = instance;
    return instance;
  }

  @Override
  public Class<?> getObjectType() {
    return configClass.get();
  }

  public Object getLastBuilt() {
    final Object lastBuilt = this.lastBuilt;
    this.lastBuilt = null;
    return lastBuilt;
  }
}
